/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import java.net.URI;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.DelegatingBaseURIAwareXMLStreamWriter;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.transform.XMLOutputValue;

public class SaxonOutputValue
extends XMLOutputValue<Void> {
    private SaxonOutputValue backingValue = null;
    private final Consumer<XdmItem> xdmItemConsumer;

    public SaxonOutputValue(Consumer<XdmItem> value, Configuration configuration) {
        super(SaxonOutputValue.createXMLStreamWriter(value, configuration));
        this.xdmItemConsumer = value;
    }

    public SaxonOutputValue(SaxonOutputValue value) {
        super((XMLOutputValue)value);
        this.backingValue = value;
        this.xdmItemConsumer = null;
    }

    public Consumer<XdmItem> asXdmItemConsumer() {
        if (this.backingValue != null) {
            return this.backingValue.asXdmItemConsumer();
        }
        return this.xdmItemConsumer;
    }

    public BaseURIAwareXMLStreamWriter asXMLStreamWriter() {
        return super.asXMLStreamWriter();
    }

    private static BaseURIAwareXMLStreamWriter createXMLStreamWriter(final Consumer<XdmItem> itemConsumer, final Configuration config) {
        return new DelegatingBaseURIAwareXMLStreamWriter(){
            private BaseURIAwareXMLStreamWriter writer = null;
            private Receiver receiver;
            private XdmDestination destination;
            private boolean seenStartDocument = false;
            private int elementDepth = 0;

            protected BaseURIAwareXMLStreamWriter delegate() {
                if (this.writer == null) {
                    try {
                        this.destination = new XdmDestination();
                        this.receiver = new NamespaceReducer(this.destination.getReceiver(config));
                        this.receiver.open();
                        this.writer = new BaseURIAwareStreamWriterToReceiver(this.receiver);
                    }
                    catch (SaxonApiException | XPathException e) {
                        throw new TransformerException(e);
                    }
                }
                return this.writer;
            }

            public void writeStartDocument() throws XMLStreamException {
                if (this.elementDepth != 0) {
                    throw new XMLStreamException();
                }
                if (this.seenStartDocument) {
                    throw new XMLStreamException();
                }
                super.writeStartDocument();
                this.seenStartDocument = true;
            }

            public void writeStartDocument(String version) throws XMLStreamException {
                if (this.elementDepth != 0) {
                    throw new XMLStreamException();
                }
                if (this.seenStartDocument) {
                    throw new XMLStreamException();
                }
                super.writeStartDocument(version);
                this.seenStartDocument = true;
            }

            public void writeStartDocument(String encoding, String version) throws XMLStreamException {
                if (this.elementDepth != 0) {
                    throw new XMLStreamException();
                }
                if (this.seenStartDocument) {
                    throw new XMLStreamException();
                }
                super.writeStartDocument(encoding, version);
                this.seenStartDocument = true;
            }

            public void writeStartElement(String localName) throws XMLStreamException {
                super.writeStartElement(localName);
                ++this.elementDepth;
            }

            public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
                super.writeStartElement(namespaceURI, localName);
                ++this.elementDepth;
            }

            public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                super.writeStartElement(prefix, localName, namespaceURI);
                ++this.elementDepth;
            }

            public void writeEndElement() throws XMLStreamException {
                if (this.elementDepth == 0) {
                    throw new XMLStreamException();
                }
                super.writeEndElement();
                --this.elementDepth;
                if (!this.seenStartDocument && this.elementDepth == 0) {
                    try {
                        this.receiver.close();
                        XdmNode doc = this.destination.getXdmNode();
                        itemConsumer.accept(doc.axisIterator(Axis.CHILD).next());
                    }
                    catch (XPathException e) {
                        throw new XMLStreamException(e);
                    }
                    this.seenStartDocument = false;
                    this.writer = null;
                }
            }

            public void writeEndDocument() throws XMLStreamException {
                if (this.elementDepth != 0) {
                    throw new XMLStreamException();
                }
                if (!this.seenStartDocument) {
                    throw new XMLStreamException();
                }
                super.writeEndDocument();
                try {
                    this.receiver.close();
                    itemConsumer.accept(this.destination.getXdmNode());
                }
                catch (XPathException e) {
                    throw new XMLStreamException(e);
                }
                this.seenStartDocument = false;
                this.writer = null;
            }
        };
    }

    private static class BaseURIAwareStreamWriterToReceiver
    extends StreamWriterToReceiver
    implements BaseURIAwareXMLStreamWriter {
        private final Receiver receiver;
        private URI baseURI = null;
        private boolean seenRoot = false;

        public BaseURIAwareStreamWriterToReceiver(Receiver receiver) {
            super(receiver);
            this.receiver = receiver;
        }

        public URI getBaseURI() throws XMLStreamException {
            return this.baseURI;
        }

        public void setBaseURI(URI baseURI) throws XMLStreamException {
            if (this.seenRoot) {
                throw new XMLStreamException("Setting base URI not supported after document has started.");
            }
            if (baseURI != null) {
                this.receiver.setSystemId(baseURI.toASCIIString());
            }
            this.baseURI = baseURI;
        }

        public void writeStartDocument() throws XMLStreamException {
            super.writeStartDocument();
            this.seenRoot = true;
        }
    }
}

