/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xpath.saxon;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.DocumentBuilderImpl;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.saxon.SaxonInputValue;
import org.daisy.common.saxon.SaxonOutputValue;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.xpath.saxon.ExtensionFunctionProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ReflexiveExtensionFunctionProvider
implements ExtensionFunctionProvider {
    private final List<ExtensionFunctionDefinition> definitions;

    @Override
    public Collection<ExtensionFunctionDefinition> getDefinitions() {
        return this.definitions;
    }

    protected ReflexiveExtensionFunctionProvider(Class<?> definition) {
        List<Executable> list;
        HashMap methods = new HashMap();
        for (Constructor<?> constructor : definition.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            list = (ArrayList)methods.get("new");
            if (list == null) {
                list = new ArrayList();
                methods.put("new", list);
            }
            list.add(constructor);
            methods.put("new", list);
        }
        for (Executable executable : definition.getDeclaredMethods()) {
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || "toString".equals(((Method)executable).getName()) && ((Method)executable).getParameterCount() == 0 && !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            list = (List)methods.get(((Method)executable).getName());
            if (list == null) {
                list = new ArrayList();
                methods.put(((Method)executable).getName(), list);
            }
            list.add(executable);
            methods.put(((Method)executable).getName(), list);
        }
        this.definitions = new ArrayList<ExtensionFunctionDefinition>();
        for (List m : methods.values()) {
            Collections.sort(m, (a, b) -> new Integer(a.getParameterCount()).compareTo(b.getParameterCount()));
            this.definitions.add(this.extensionFunctionDefinitionFromMethods(m));
        }
    }

    private ExtensionFunctionDefinition extensionFunctionDefinitionFromMethods(Collection<Executable> methods) throws IllegalArgumentException {
        ExtensionFunctionDefinition ret = null;
        for (Executable m : methods) {
            ExtensionFunctionDefinition def = this.extensionFunctionDefinitionFromMethod(m);
            if (ret == null) {
                ret = def;
                continue;
            }
            final ExtensionFunctionDefinition defA = ret;
            final ExtensionFunctionDefinition defB = def;
            final StructuredQName funcName = defA.getFunctionQName();
            if (!defB.getFunctionQName().equals((Object)funcName)) {
                throw new IllegalArgumentException();
            }
            final SequenceType[] argTypes = defB.getArgumentTypes();
            if (defB.getMinimumNumberOfArguments() <= defA.getMaximumNumberOfArguments() || !Arrays.equals(Arrays.copyOfRange(argTypes, 0, defA.getArgumentTypes().length), defA.getArgumentTypes())) {
                if (m instanceof Constructor) {
                    throw new IllegalArgumentException("Incompatible constructors");
                }
                throw new IllegalArgumentException("Incompatible '" + m.getName() + "' methods");
            }
            final int minArgs = defA.getMinimumNumberOfArguments();
            final int maxArgs = defB.getMaximumNumberOfArguments();
            ret = new ExtensionFunctionDefinition(){

                public StructuredQName getFunctionQName() {
                    return funcName;
                }

                public int getMinimumNumberOfArguments() {
                    return minArgs;
                }

                public int getMaximumNumberOfArguments() {
                    return maxArgs;
                }

                public SequenceType[] getArgumentTypes() {
                    return argTypes;
                }

                public SequenceType getResultType(SequenceType[] suppliedArgTypes) {
                    if (suppliedArgTypes.length >= defB.getMinimumNumberOfArguments()) {
                        return defB.getResultType(suppliedArgTypes);
                    }
                    if (suppliedArgTypes.length <= defA.getMaximumNumberOfArguments()) {
                        return defA.getResultType(suppliedArgTypes);
                    }
                    throw new IllegalArgumentException("Function " + funcName + " can not be called with " + suppliedArgTypes.length + " arguments");
                }

                public ExtensionFunctionCall makeCallExpression() {
                    return new ExtensionFunctionCall(){
                        ExtensionFunctionCall callA = null;
                        ExtensionFunctionCall callB = null;

                        public Sequence call(XPathContext ctxt, Sequence[] args) throws XPathException {
                            if (args.length <= defA.getMaximumNumberOfArguments()) {
                                if (this.callA == null) {
                                    this.callA = defA.makeCallExpression();
                                }
                                return this.callA.call(ctxt, args);
                            }
                            if (args.length >= defB.getMinimumNumberOfArguments()) {
                                if (this.callB == null) {
                                    this.callB = defB.makeCallExpression();
                                }
                                return this.callB.call(ctxt, args);
                            }
                            throw new IllegalArgumentException("Function " + funcName + " can not be called with " + args.length + " arguments");
                        }
                    };
                }
            };
        }
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private ExtensionFunctionDefinition extensionFunctionDefinitionFromMethod(final Executable method) throws IllegalArgumentException {
        void var12_18;
        assert (method instanceof Constructor || method instanceof Method);
        if (method.isVarArgs()) {
            throw new IllegalArgumentException();
        }
        final Class<?> declaringClass = method.getDeclaringClass();
        boolean isInnerClass = Arrays.stream(this.getClass().getClasses()).anyMatch(declaringClass::equals) && !Modifier.isStatic(declaringClass.getModifiers());
        final boolean isConstructor = method instanceof Constructor;
        boolean isStatic = isConstructor || Modifier.isStatic(method.getModifiers());
        boolean requiresXMLStreamWriter = false;
        boolean requiresXPath = false;
        boolean requiresDocumentBuilder = false;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (clazz.equals(XPath.class)) {
                if (requiresXPath) {
                    throw new IllegalArgumentException();
                }
                requiresXPath = true;
                continue;
            }
            if (clazz.equals(DocumentBuilder.class)) {
                if (requiresDocumentBuilder) {
                    throw new IllegalArgumentException();
                }
                requiresDocumentBuilder = true;
                continue;
            }
            if (!clazz.equals(XMLStreamWriter.class)) continue;
            if (requiresXMLStreamWriter) {
                throw new IllegalArgumentException();
            }
            requiresXMLStreamWriter = true;
        }
        Type[] types = method.getGenericParameterTypes();
        Type[] javaArgumentTypes = isConstructor && isInnerClass ? Arrays.copyOfRange(types, 1, types.length) : types;
        final SequenceType[] argumentTypes = new SequenceType[javaArgumentTypes.length + (isStatic ? 0 : 1) - (requiresXMLStreamWriter ? 1 : 0) - (requiresXPath ? 1 : 0) - (requiresDocumentBuilder ? 1 : 0)];
        int i = 0;
        if (!isStatic) {
            argumentTypes[i++] = SequenceType.SINGLE_ITEM;
        }
        for (Type t : javaArgumentTypes) {
            if (t.equals(XMLStreamWriter.class) || t.equals(XPath.class) || t.equals(DocumentBuilder.class)) continue;
            argumentTypes[i++] = ReflexiveExtensionFunctionProvider.sequenceTypeFromType(t);
        }
        if (isConstructor) {
            if (requiresXMLStreamWriter) {
                throw new IllegalArgumentException();
            }
            SequenceType sequenceType = SequenceType.SINGLE_ITEM;
        } else {
            Type t = ((Method)method).getGenericReturnType();
            if (requiresXMLStreamWriter) {
                if (!t.equals(Void.TYPE)) {
                    throw new IllegalArgumentException();
                }
                SequenceType sequenceType = SequenceType.NODE_SEQUENCE;
            } else {
                SequenceType sequenceType = ReflexiveExtensionFunctionProvider.sequenceTypeFromType(t);
            }
        }
        return new ExtensionFunctionDefinition((SequenceType)var12_18, isStatic, isInnerClass, javaArgumentTypes){
            final /* synthetic */ SequenceType val$resultType;
            final /* synthetic */ boolean val$isStatic;
            final /* synthetic */ boolean val$isInnerClass;
            final /* synthetic */ Type[] val$javaArgumentTypes;
            {
                this.val$resultType = sequenceType;
                this.val$isStatic = bl2;
                this.val$isInnerClass = bl3;
                this.val$javaArgumentTypes = typeArray;
            }

            public SequenceType[] getArgumentTypes() {
                return argumentTypes;
            }

            public StructuredQName getFunctionQName() {
                return new StructuredQName(declaringClass.getSimpleName(), declaringClass.getName(), isConstructor ? "new" : method.getName());
            }

            public SequenceType getResultType(SequenceType[] suppliedArgTypes) {
                return this.val$resultType;
            }

            public ExtensionFunctionCall makeCallExpression() {
                return new ExtensionFunctionCall(){

                    public Sequence call(XPathContext ctxt, Sequence[] args) throws XPathException {
                        try {
                            Object result;
                            if (args.length != argumentTypes.length) {
                                throw new IllegalArgumentException();
                            }
                            int i = 0;
                            Object instance = null;
                            if (!val$isStatic) {
                                Item item2 = ReflexiveExtensionFunctionProvider.getSingleItem(args[i++]);
                                try {
                                    instance = ReflexiveExtensionFunctionProvider.objectFromItem(item2, declaringClass);
                                }
                                catch (IllegalArgumentException e) {
                                    throw new IllegalArgumentException("Expected ObjectValue<" + declaringClass.getSimpleName() + ">" + ", but got: " + item2, e);
                                }
                            }
                            ArrayList nodeListFromXMLStreamWriter = null;
                            Object[] javaArgs = new Object[method.getParameterCount()];
                            int j = 0;
                            if (isConstructor && val$isInnerClass) {
                                javaArgs[j++] = ReflexiveExtensionFunctionProvider.this;
                            }
                            for (Type type : val$javaArgumentTypes) {
                                Optional item3;
                                if (type.equals(XMLStreamWriter.class)) {
                                    ArrayList list;
                                    nodeListFromXMLStreamWriter = list = new ArrayList();
                                    BaseURIAwareXMLStreamWriter xmlStreamWriterArg = new SaxonOutputValue(item -> {
                                        if (!(item instanceof XdmNode)) {
                                            throw new RuntimeException();
                                        }
                                        list.add(((XdmNode)item).getUnderlyingNode());
                                    }, ctxt.getConfiguration()).asXMLStreamWriter();
                                    javaArgs[j++] = xmlStreamWriterArg;
                                    continue;
                                }
                                if (type.equals(XPath.class)) {
                                    javaArgs[j++] = new XPathFactoryImpl(ctxt.getConfiguration()).newXPath();
                                    continue;
                                }
                                if (type.equals(DocumentBuilder.class)) {
                                    DocumentBuilderImpl b = new DocumentBuilderImpl();
                                    b.setConfiguration(ctxt.getConfiguration());
                                    javaArgs[j++] = b;
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Iterator.class)) {
                                    javaArgs[j++] = ReflexiveExtensionFunctionProvider.iteratorFromSequence(args[i++], ((ParameterizedType)type).getActualTypeArguments()[0]);
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Iterable.class)) {
                                    javaArgs[j++] = ReflexiveExtensionFunctionProvider.iterableFromSequence(args[i++], ((ParameterizedType)type).getActualTypeArguments()[0]);
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Optional.class)) {
                                    item3 = ReflexiveExtensionFunctionProvider.getOptionalItem(args[i++]);
                                    javaArgs[j++] = item3.isPresent() ? Optional.of(ReflexiveExtensionFunctionProvider.objectFromItem((Item)item3.get(), ((ParameterizedType)type).getActualTypeArguments()[0])) : Optional.empty();
                                    continue;
                                }
                                if (type.equals(URI.class)) {
                                    if (!(item3 = ReflexiveExtensionFunctionProvider.getOptionalItem(args[i++])).isPresent()) {
                                        throw new IllegalArgumentException("Expected xs:anyURI but got an empty sequence");
                                    }
                                    javaArgs[j++] = ReflexiveExtensionFunctionProvider.objectFromItem((Item)item3.get(), type);
                                    continue;
                                }
                                javaArgs[j++] = ReflexiveExtensionFunctionProvider.objectFromItem(ReflexiveExtensionFunctionProvider.getSingleItem(args[i++]), type);
                            }
                            try {
                                result = isConstructor ? ((Constructor)method).newInstance(javaArgs) : ((Method)method).invoke(instance, javaArgs);
                            }
                            catch (InstantiationException | InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof XPathException) {
                                    throw (XPathException)cause;
                                }
                                if (cause instanceof TransformerException) {
                                    XPathException xpe = new XPathException(cause.getMessage(), cause.getCause());
                                    QName code = ((TransformerException)cause).getCode();
                                    xpe.setErrorCodeQName(new StructuredQName(code.getPrefix(), code.getNamespaceURI(), code.getLocalPart()));
                                    throw xpe;
                                }
                                throw new XPathException(cause);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException();
                            }
                            if (nodeListFromXMLStreamWriter != null) {
                                return new SequenceExtent(nodeListFromXMLStreamWriter);
                            }
                            if (result instanceof Optional) {
                                return SaxonHelper.sequenceFromObject(((Optional)result).orElse(null));
                            }
                            return SaxonHelper.sequenceFromObject(result);
                        }
                        catch (RuntimeException e) {
                            throw new XPathException("Unexpected error in " + this.getFunctionQName().getClarkName(), (Throwable)e);
                        }
                    }
                };
            }
        };
    }

    private static SequenceType sequenceTypeFromType(Type type) throws IllegalArgumentException {
        if (type.equals(Void.TYPE)) {
            return SequenceType.EMPTY_SEQUENCE;
        }
        if (type.equals(String.class)) {
            return SequenceType.SINGLE_STRING;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE)) {
            return SequenceType.SINGLE_INTEGER;
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return SequenceType.SINGLE_FLOAT;
        }
        if (type.equals(BigDecimal.class)) {
            return SequenceType.SINGLE_DECIMAL;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return SequenceType.SINGLE_BOOLEAN;
        }
        if (type.equals(URI.class)) {
            return SequenceType.OPTIONAL_ANY_URI;
        }
        if (type.equals(Element.class) || type.equals(Node.class) || type.equals(Attr.class)) {
            return SequenceType.SINGLE_NODE;
        }
        if (type.equals(Object.class)) {
            return SequenceType.SINGLE_ITEM;
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class<?> itemType = ((Class)type).getComponentType();
            ReflexiveExtensionFunctionProvider.sequenceTypeFromType(itemType);
            return ArrayItem.SINGLE_ARRAY_TYPE;
        }
        if (type instanceof ParameterizedType) {
            Type keyType;
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType.equals(Optional.class)) {
                Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (itemType.equals(Node.class) || itemType.equals(Element.class) || itemType.equals(Attr.class)) {
                    return SequenceType.OPTIONAL_NODE;
                }
                if (itemType.equals(String.class)) {
                    return SequenceType.OPTIONAL_STRING;
                }
                if (itemType.equals(URI.class)) {
                    return SequenceType.OPTIONAL_ANY_URI;
                }
                if (itemType.equals(Object.class)) {
                    return SequenceType.OPTIONAL_ITEM;
                }
                if (itemType instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)itemType).getRawType();
                    if (rawType.equals(Iterator.class) || rawType.equals(Iterable.class)) {
                        return ReflexiveExtensionFunctionProvider.sequenceTypeFromType(itemType);
                    }
                    return SequenceType.OPTIONAL_ITEM;
                }
                return SequenceType.OPTIONAL_ITEM;
            }
            if (rawType.equals(Iterator.class) || rawType.equals(Iterable.class)) {
                Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (itemType.equals(Node.class)) {
                    return SequenceType.NODE_SEQUENCE;
                }
                if (itemType.equals(String.class)) {
                    return SequenceType.STRING_SEQUENCE;
                }
                return SequenceType.ANY_SEQUENCE;
            }
            if (rawType.equals(Map.class) && (keyType = ((ParameterizedType)type).getActualTypeArguments()[0]).equals(String.class)) {
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                ReflexiveExtensionFunctionProvider.sequenceTypeFromType(valueType);
                return HashTrieMap.SINGLE_MAP_TYPE;
            }
        } else {
            return SequenceType.SINGLE_ITEM;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static Iterable<?> iterableFromSequence(Sequence sequence, Type itemType) throws XPathException {
        Item next;
        if (itemType instanceof Class) {
            return ReflexiveExtensionFunctionProvider.iterableFromSequence(sequence, (Class)itemType);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(ReflexiveExtensionFunctionProvider.objectFromItem(next, itemType));
        }
        return list;
    }

    private static <T> Iterable<T> iterableFromSequence(Sequence sequence, Class<T> itemType) throws XPathException {
        Item next;
        if (itemType.equals(Node.class)) {
            return ImmutableList.copyOf(ReflexiveExtensionFunctionProvider.iteratorFromNodeSequence(sequence));
        }
        ArrayList<T> list = new ArrayList<T>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(ReflexiveExtensionFunctionProvider.objectFromItem(next, itemType));
        }
        return list;
    }

    private static Iterator<?> iteratorFromSequence(Sequence sequence, Type itemType) throws XPathException {
        if (itemType.equals(Node.class)) {
            return ReflexiveExtensionFunctionProvider.iteratorFromSequence(sequence, (Class)itemType);
        }
        return ReflexiveExtensionFunctionProvider.iterableFromSequence(sequence, itemType).iterator();
    }

    private static <T> Iterator<T> iteratorFromSequence(Sequence sequence, Class<T> itemType) throws XPathException {
        if (itemType.equals(Node.class)) {
            return ReflexiveExtensionFunctionProvider.iteratorFromNodeSequence(sequence);
        }
        return ReflexiveExtensionFunctionProvider.iterableFromSequence(sequence, itemType).iterator();
    }

    private static Iterator<Node> iteratorFromNodeSequence(Sequence sequence) throws XPathException {
        Item next;
        ArrayList<XdmNode> list = new ArrayList<XdmNode>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(ReflexiveExtensionFunctionProvider.objectFromItem(next, XdmNode.class));
        }
        return list.isEmpty() ? Collections.EMPTY_LIST.iterator() : new SaxonInputValue(list.iterator()).asNodeIterator();
    }

    private static <T> T[] arrayFromArrayItem(ArrayItem array, Class<T> itemType) throws XPathException {
        Object[] a = (Object[])Array.newInstance(itemType, array.arrayLength());
        int i = 0;
        for (Sequence s : array) {
            a[i++] = ReflexiveExtensionFunctionProvider.objectFromItem(ReflexiveExtensionFunctionProvider.getSingleItem(s), itemType);
        }
        return a;
    }

    private static Map<String, Object> mapFromMapItem(MapItem item, Type itemType) throws XPathException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (KeyValuePair kv : item) {
            map.put(kv.key.getStringValue(), ReflexiveExtensionFunctionProvider.objectFromItem(ReflexiveExtensionFunctionProvider.getSingleItem(kv.value), itemType));
        }
        return map;
    }

    private static Object objectFromItem(Item item, Type type) throws XPathException {
        Type rawType;
        if (type instanceof Class) {
            return ReflexiveExtensionFunctionProvider.objectFromItem(item, (Class)type);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()).equals(Map.class) && item instanceof MapItem) {
            return ReflexiveExtensionFunctionProvider.mapFromMapItem((MapItem)item, ((ParameterizedType)type).getActualTypeArguments()[1]);
        }
        throw new IllegalArgumentException();
    }

    private static <T> T objectFromItem(Item item, Class<T> type) throws XPathException {
        if (type.isArray()) {
            if (item instanceof ArrayItem) {
                return (T)ReflexiveExtensionFunctionProvider.arrayFromArrayItem((ArrayItem)item, type.getComponentType());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(XdmNode.class)) {
            if (item instanceof NodeInfo) {
                return (T)new XdmNode((NodeInfo)item);
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Element.class)) {
            if (item instanceof NodeInfo) {
                return (T)ElementOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Attr.class)) {
            if (item instanceof NodeInfo) {
                return (T)AttrOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Node.class)) {
            if (item instanceof NodeInfo) {
                return (T)NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(String.class)) {
            if (item instanceof StringValue) {
                return (T)((StringValue)item).getStringValue();
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            if (item instanceof IntegerValue) {
                return (T)Integer.valueOf(((IntegerValue)item).asBigInteger().intValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            if (item instanceof IntegerValue) {
                return (T)Long.valueOf(((IntegerValue)item).asBigInteger().longValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            if (item instanceof FloatValue) {
                return (T)Float.valueOf(((FloatValue)item).getFloatValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(BigDecimal.class)) {
            if (item instanceof DecimalValue) {
                try {
                    return (T)((DecimalValue)item).getDecimalValue();
                }
                catch (ValidationException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Boolean.class)) {
            if (item instanceof BooleanValue) {
                return (T)Boolean.valueOf(((BooleanValue)item).getBooleanValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(URI.class)) {
            if (item instanceof AnyURIValue) {
                try {
                    return (T)new URI(((StringValue)item).getStringValue());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Locale.class)) {
            if (item instanceof StringValue) {
                try {
                    return (T)new Locale.Builder().setLanguageTag(((StringValue)item).getStringValue().replace('_', '-')).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Object.class)) {
            if (item instanceof ArrayItem) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, Object[].class);
            }
            if (item instanceof NodeInfo) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, Node.class);
            }
            if (item instanceof StringValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, String.class);
            }
            if (item instanceof IntegerValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, Long.class);
            }
            if (item instanceof FloatValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, Float.class);
            }
            if (item instanceof DecimalValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, BigDecimal.class);
            }
            if (item instanceof BooleanValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, Boolean.class);
            }
            if (item instanceof AnyURIValue) {
                return (T)ReflexiveExtensionFunctionProvider.objectFromItem(item, URI.class);
            }
        }
        if (item instanceof ObjectValue) {
            Object o = ((ObjectValue)item).getObject();
            if (type.isInstance(o)) {
                return (T)o;
            }
            throw new IllegalArgumentException("expected " + type + " object, but got " + o);
        }
        throw new IllegalArgumentException();
    }

    private static Item getSingleItem(Sequence sequence) throws XPathException {
        SequenceIterator iterator = sequence.iterate();
        Item item = iterator.next();
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (iterator.next() != null) {
            throw new IllegalArgumentException();
        }
        return item;
    }

    private static Optional<Item> getOptionalItem(Sequence sequence) throws XPathException {
        SequenceIterator iterator = sequence.iterate();
        Item item = iterator.next();
        if (iterator.next() != null) {
            throw new IllegalArgumentException();
        }
        return Optional.ofNullable(item);
    }
}

