/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xpath.saxon;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.trans.XPathException;
import org.daisy.common.xpath.saxon.ExtensionFunctionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="xpath-registry", service={XPathFunctionRegistry.class})
public class XPathFunctionRegistry {
    private static final Logger mLogger = LoggerFactory.getLogger(XPathFunctionRegistry.class);
    HashMap<QName, ExtensionFunctionDefinition> mFunctions = new HashMap();

    @Reference(name="ExtensionFunctionDefinition", unbind="-", service=ExtensionFunctionDefinition.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addFunction(ExtensionFunctionDefinition functionDefinition) throws XPathException {
        mLogger.info("Adding extension function definition to registry {}", (Object)functionDefinition.getFunctionQName().toString());
        this.mFunctions.put(functionDefinition.getFunctionQName().toJaxpQName(), functionDefinition);
    }

    public void removeFunction(ExtensionFunctionDefinition functionDefinition) {
        mLogger.info("Deleting extension function definition to registry {}", (Object)functionDefinition.getFunctionQName().toString());
        this.mFunctions.remove(functionDefinition.getFunctionQName().toJaxpQName());
    }

    @Reference(name="ExtensionFunctionProvider", unbind="-", service=ExtensionFunctionProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addFunctionProvider(ExtensionFunctionProvider functionProvider) throws XPathException {
        for (ExtensionFunctionDefinition f : functionProvider.getDefinitions()) {
            this.addFunction(f);
        }
    }

    public void removeFunctionProvider(ExtensionFunctionProvider functionProvider) {
        for (ExtensionFunctionDefinition f : functionProvider.getDefinitions()) {
            this.removeFunction(f);
        }
    }

    public Set<ExtensionFunctionDefinition> getFunctions() {
        return new HashSet<ExtensionFunctionDefinition>(this.mFunctions.values());
    }
}

