/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xpath.saxon;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.daisy.common.spi.ServiceLoader;
import org.daisy.common.spi.ServiceWithProperties;
import org.daisy.common.xpath.saxon.ExtensionFunctionProvider;
import org.daisy.common.xpath.saxon.XPathFunctionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathFunctionRegistry_SPI
extends XPathFunctionRegistry
implements ServiceWithProperties {
    private static final Logger spi_log = LoggerFactory.getLogger(XPathFunctionRegistry_SPI.class);
    private final Map spi_props;
    private boolean spi_deactivated = false;

    public XPathFunctionRegistry_SPI() {
        Object service;
        Iterator services;
        spi_log.trace("Creating XPathFunctionRegistry");
        this.spi_props = new HashMap();
        this.spi_props.put("component.name", "xpath-registry");
        spi_log.trace("Binding net.sf.saxon.lib.ExtensionFunctionDefinition services...");
        int minRef = 0;
        int maxRef = -1;
        int refCount = 0;
        try {
            services = ServiceLoader.load(ExtensionFunctionDefinition.class).iterator();
            while (services.hasNext()) {
                try {
                    service = (ExtensionFunctionDefinition)services.next();
                    this.addFunction((ExtensionFunctionDefinition)service);
                    spi_log.trace("Bound net.sf.saxon.lib.ExtensionFunctionDefinition service: " + service.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(service)));
                    if (maxRef <= 0 || ++refCount != maxRef) continue;
                    break;
                }
                catch (Throwable e) {
                    spi_log.error("Error while binding net.sf.saxon.lib.ExtensionFunctionDefinition service", e);
                }
            }
        }
        catch (Throwable e) {
            spi_log.error("Error while binding net.sf.saxon.lib.ExtensionFunctionDefinition services", e);
        }
        if (refCount < minRef) {
            spi_log.warn("No net.sf.saxon.lib.ExtensionFunctionDefinition found");
            throw new RuntimeException("No net.sf.saxon.lib.ExtensionFunctionDefinition found");
        }
        spi_log.trace("Bound " + refCount + " net.sf.saxon.lib.ExtensionFunctionDefinition services.");
        spi_log.trace("Binding org.daisy.common.xpath.saxon.ExtensionFunctionProvider services...");
        minRef = 0;
        maxRef = -1;
        refCount = 0;
        try {
            services = ServiceLoader.load(ExtensionFunctionProvider.class).iterator();
            while (services.hasNext()) {
                try {
                    service = (ExtensionFunctionProvider)services.next();
                    this.addFunctionProvider((ExtensionFunctionProvider)service);
                    spi_log.trace("Bound org.daisy.common.xpath.saxon.ExtensionFunctionProvider service: " + service.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(service)));
                    if (maxRef <= 0 || ++refCount != maxRef) continue;
                    break;
                }
                catch (Throwable e) {
                    spi_log.error("Error while binding org.daisy.common.xpath.saxon.ExtensionFunctionProvider service", e);
                }
            }
        }
        catch (Throwable e) {
            spi_log.error("Error while binding org.daisy.common.xpath.saxon.ExtensionFunctionProvider services", e);
        }
        if (refCount < minRef) {
            spi_log.warn("No org.daisy.common.xpath.saxon.ExtensionFunctionProvider found");
            throw new RuntimeException("No org.daisy.common.xpath.saxon.ExtensionFunctionProvider found");
        }
        spi_log.trace("Bound " + refCount + " org.daisy.common.xpath.saxon.ExtensionFunctionProvider services.");
    }

    public void spi_deactivate() {
    }

    public Map spi_getProperties() {
        return this.spi_props;
    }
}

