/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.daisy.common.saxon.SaxonInputValue;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SaxonHelper {
    public static Sequence sequenceFromObject(Object object) {
        if (object == null) {
            return EmptySequence.getInstance();
        }
        if (object instanceof Iterator || object instanceof Iterable) {
            return SaxonHelper.sequenceFromIterator(object instanceof Iterable ? ((Iterable)object).iterator() : (Iterator)object);
        }
        if (object.getClass().isArray()) {
            return SaxonHelper.arrayItemFromIterator(Arrays.asList((Object[])object).iterator());
        }
        return SaxonHelper.itemFromObject(object);
    }

    private static Item itemFromObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            return new StringValue((CharSequence)((String)object));
        }
        if (object instanceof Integer) {
            return IntegerValue.makeIntegerValue((BigInteger)BigInteger.valueOf(((Integer)object).intValue()));
        }
        if (object instanceof Long) {
            return IntegerValue.makeIntegerValue((BigInteger)BigInteger.valueOf((Long)object));
        }
        if (object instanceof Float) {
            return FloatValue.makeFloatValue((float)((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DoubleValue.makeDoubleValue((double)((Double)object));
        }
        if (object instanceof BigDecimal) {
            return new BigDecimalValue((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)object));
        }
        if (object instanceof URI) {
            return new AnyURIValue((CharSequence)((URI)object).toASCIIString());
        }
        if (object instanceof Locale) {
            return SaxonHelper.itemFromObject(((Locale)object).toLanguageTag());
        }
        if (object instanceof Map) {
            return SaxonHelper.mapItemFromMap((Map)object);
        }
        return new ObjectValue(object);
    }

    private static Sequence sequenceFromIterator(Iterator<?> iterator) {
        ArrayList<Item> list = new ArrayList<Item>();
        while (iterator.hasNext()) {
            list.add(SaxonHelper.itemFromObject(iterator.next()));
        }
        return new SequenceExtent(list);
    }

    private static MapItem mapItemFromMap(Map<?, ?> map) {
        HashTrieMap mapItem = new HashTrieMap();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException();
            }
            mapItem = mapItem.addEntry((AtomicValue)new StringValue((CharSequence)((String)key)), SaxonHelper.sequenceFromObject(map.get(key)));
        }
        return mapItem;
    }

    private static ArrayItem arrayItemFromIterator(Iterator<?> iterator) {
        try {
            return SimpleArrayItem.makeSimpleArrayItem((SequenceIterator)SaxonHelper.sequenceFromIterator(iterator).iterate());
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    public static XdmValue xdmValueFromObject(Object object) {
        if (object == null) {
            return XdmValue.wrap((Sequence)EmptySequence.getInstance());
        }
        if (object instanceof String) {
            return new XdmAtomicValue((String)object);
        }
        if (object instanceof Integer) {
            return new XdmAtomicValue(((Integer)object).intValue());
        }
        if (object instanceof Boolean) {
            return new XdmAtomicValue(((Boolean)object).booleanValue());
        }
        if (object instanceof URI) {
            return new XdmAtomicValue((URI)object);
        }
        try {
            return XdmValue.wrap((Sequence)SaxonHelper.sequenceFromObject(object));
        }
        catch (IllegalArgumentException e) {
            return XdmValue.wrap((Sequence)new ObjectValue(object));
        }
    }

    public static SequenceType sequenceTypeFromType(Type type) throws IllegalArgumentException {
        if (type.equals(Void.TYPE)) {
            return SequenceType.EMPTY_SEQUENCE;
        }
        if (type.equals(String.class)) {
            return SequenceType.SINGLE_STRING;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE)) {
            return SequenceType.SINGLE_INTEGER;
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return SequenceType.SINGLE_FLOAT;
        }
        if (type.equals(BigDecimal.class)) {
            return SequenceType.SINGLE_DECIMAL;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return SequenceType.SINGLE_BOOLEAN;
        }
        if (type.equals(URI.class)) {
            return SequenceType.OPTIONAL_ANY_URI;
        }
        if (type.equals(Element.class) || type.equals(Node.class) || type.equals(Attr.class)) {
            return SequenceType.SINGLE_NODE;
        }
        if (type.equals(Object.class)) {
            return SequenceType.SINGLE_ITEM;
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class<?> itemType = ((Class)type).getComponentType();
            SaxonHelper.sequenceTypeFromType(itemType);
            return ArrayItem.SINGLE_ARRAY_TYPE;
        }
        if (type instanceof ParameterizedType) {
            Type keyType;
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType.equals(Optional.class)) {
                Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (itemType.equals(Node.class) || itemType.equals(Element.class) || itemType.equals(Attr.class)) {
                    return SequenceType.OPTIONAL_NODE;
                }
                if (itemType.equals(String.class)) {
                    return SequenceType.OPTIONAL_STRING;
                }
                if (itemType.equals(URI.class)) {
                    return SequenceType.OPTIONAL_ANY_URI;
                }
                if (itemType.equals(Object.class)) {
                    return SequenceType.OPTIONAL_ITEM;
                }
                if (itemType instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)itemType).getRawType();
                    if (rawType.equals(Iterator.class) || rawType.equals(Iterable.class)) {
                        return SaxonHelper.sequenceTypeFromType(itemType);
                    }
                    return SequenceType.OPTIONAL_ITEM;
                }
                return SequenceType.OPTIONAL_ITEM;
            }
            if (rawType.equals(Iterator.class) || rawType.equals(Iterable.class)) {
                Type itemType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (itemType.equals(Node.class)) {
                    return SequenceType.NODE_SEQUENCE;
                }
                if (itemType.equals(String.class)) {
                    return SequenceType.STRING_SEQUENCE;
                }
                return SequenceType.ANY_SEQUENCE;
            }
            if (rawType.equals(Map.class) && (keyType = ((ParameterizedType)type).getActualTypeArguments()[0]).equals(String.class)) {
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                SaxonHelper.sequenceTypeFromType(valueType);
                return HashTrieMap.SINGLE_MAP_TYPE;
            }
        } else {
            return SequenceType.SINGLE_ITEM;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static Iterable<?> iterableFromSequence(Sequence sequence, Type itemType) throws XPathException {
        Item next;
        if (itemType instanceof Class) {
            return SaxonHelper.iterableFromSequence(sequence, (Class)itemType);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(SaxonHelper.objectFromItem(next, itemType));
        }
        return list;
    }

    public static <T> Iterable<T> iterableFromSequence(Sequence sequence, Class<T> itemType) throws XPathException {
        Item next;
        if (itemType.equals(Node.class)) {
            return ImmutableList.copyOf(SaxonHelper.iteratorFromNodeSequence(sequence));
        }
        ArrayList<T> list = new ArrayList<T>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(SaxonHelper.objectFromItem(next, itemType));
        }
        return list;
    }

    public static Iterator<?> iteratorFromSequence(Sequence sequence, Type itemType) throws XPathException {
        if (itemType.equals(Node.class)) {
            return SaxonHelper.iteratorFromSequence(sequence, (Class)itemType);
        }
        return SaxonHelper.iterableFromSequence(sequence, itemType).iterator();
    }

    public static <T> Iterator<T> iteratorFromSequence(Sequence sequence, Class<T> itemType) throws XPathException {
        if (itemType.equals(Node.class)) {
            return SaxonHelper.iteratorFromNodeSequence(sequence);
        }
        return SaxonHelper.iterableFromSequence(sequence, itemType).iterator();
    }

    private static Iterator<Node> iteratorFromNodeSequence(Sequence sequence) throws XPathException {
        Item next;
        ArrayList<XdmNode> list = new ArrayList<XdmNode>();
        SequenceIterator iterator = sequence.iterate();
        while ((next = iterator.next()) != null) {
            list.add(SaxonHelper.objectFromItem(next, XdmNode.class));
        }
        return list.isEmpty() ? Collections.EMPTY_LIST.iterator() : new SaxonInputValue(list.iterator()).asNodeIterator();
    }

    public static <T> T[] arrayFromArrayItem(ArrayItem array, Class<T> itemType) throws XPathException {
        Object[] a = (Object[])Array.newInstance(itemType, array.arrayLength());
        int i = 0;
        for (Sequence s : array) {
            a[i++] = SaxonHelper.objectFromItem(SaxonHelper.getSingleItem(s), itemType);
        }
        return a;
    }

    public static Map<String, ?> mapFromMapItem(MapItem item, Type itemType) throws XPathException {
        if (itemType instanceof Class) {
            return SaxonHelper.mapFromMapItem(item, (Class)itemType);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (KeyValuePair kv : item) {
            map.put(kv.key.getStringValue(), SaxonHelper.objectFromItem(SaxonHelper.getSingleItem(kv.value), itemType));
        }
        return map;
    }

    public static <T> Map<String, T> mapFromMapItem(MapItem item, Class<T> itemType) throws XPathException {
        HashMap<String, T> map = new HashMap<String, T>();
        for (KeyValuePair kv : item) {
            map.put(kv.key.getStringValue(), SaxonHelper.objectFromItem(SaxonHelper.getSingleItem(kv.value), itemType));
        }
        return map;
    }

    public static Object objectFromItem(Item item, Type type) throws XPathException {
        Type rawType;
        if (type instanceof Class) {
            return SaxonHelper.objectFromItem(item, (Class)type);
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()).equals(Map.class) && item instanceof MapItem) {
            return SaxonHelper.mapFromMapItem((MapItem)item, ((ParameterizedType)type).getActualTypeArguments()[1]);
        }
        throw new IllegalArgumentException();
    }

    public static <T> T objectFromItem(Item item, Class<T> type) throws XPathException {
        if (type.isArray()) {
            if (item instanceof ArrayItem) {
                return (T)SaxonHelper.arrayFromArrayItem((ArrayItem)item, type.getComponentType());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(XdmNode.class)) {
            if (item instanceof NodeInfo) {
                return (T)new XdmNode((NodeInfo)item);
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Element.class)) {
            if (item instanceof NodeInfo) {
                return (T)ElementOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Attr.class)) {
            if (item instanceof NodeInfo) {
                return (T)AttrOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Node.class)) {
            if (item instanceof NodeInfo) {
                return (T)NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)item));
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(String.class)) {
            if (item instanceof StringValue) {
                return (T)((StringValue)item).getStringValue();
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            if (item instanceof IntegerValue) {
                return (T)Integer.valueOf(((IntegerValue)item).asBigInteger().intValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            if (item instanceof IntegerValue) {
                return (T)Long.valueOf(((IntegerValue)item).asBigInteger().longValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            if (item instanceof FloatValue) {
                return (T)Float.valueOf(((FloatValue)item).getFloatValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(BigDecimal.class)) {
            if (item instanceof DecimalValue) {
                try {
                    return (T)((DecimalValue)item).getDecimalValue();
                }
                catch (ValidationException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Boolean.class)) {
            if (item instanceof BooleanValue) {
                return (T)Boolean.valueOf(((BooleanValue)item).getBooleanValue());
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(URI.class)) {
            if (item instanceof AnyURIValue) {
                try {
                    return (T)new URI(((StringValue)item).getStringValue());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Locale.class)) {
            if (item instanceof StringValue) {
                try {
                    return (T)new Locale.Builder().setLanguageTag(((StringValue)item).getStringValue().replace('_', '-')).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals(Object.class)) {
            if (item instanceof ArrayItem) {
                return (T)SaxonHelper.objectFromItem(item, Object[].class);
            }
            if (item instanceof NodeInfo) {
                return (T)SaxonHelper.objectFromItem(item, Node.class);
            }
            if (item instanceof StringValue) {
                return (T)SaxonHelper.objectFromItem(item, String.class);
            }
            if (item instanceof IntegerValue) {
                return (T)SaxonHelper.objectFromItem(item, Long.class);
            }
            if (item instanceof FloatValue) {
                return (T)SaxonHelper.objectFromItem(item, Float.class);
            }
            if (item instanceof DecimalValue) {
                return (T)SaxonHelper.objectFromItem(item, BigDecimal.class);
            }
            if (item instanceof BooleanValue) {
                return (T)SaxonHelper.objectFromItem(item, Boolean.class);
            }
            if (item instanceof AnyURIValue) {
                return (T)SaxonHelper.objectFromItem(item, URI.class);
            }
        }
        if (item instanceof ObjectValue) {
            Object o = ((ObjectValue)item).getObject();
            if (type.isInstance(o)) {
                return (T)o;
            }
            throw new IllegalArgumentException("expected " + type + " object, but got " + o);
        }
        throw new IllegalArgumentException();
    }

    public static Item getSingleItem(Sequence sequence) throws XPathException {
        SequenceIterator iterator = sequence.iterate();
        Item item = iterator.next();
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (iterator.next() != null) {
            throw new IllegalArgumentException();
        }
        return item;
    }

    public static Optional<Item> getOptionalItem(Sequence sequence) throws XPathException {
        SequenceIterator iterator = sequence.iterate();
        Item item = iterator.next();
        if (iterator.next() != null) {
            throw new IllegalArgumentException();
        }
        return Optional.ofNullable(item);
    }

    public static QName jaxpQName(net.sf.saxon.s9api.QName name) {
        String prefix = name.getPrefix();
        String ns = name.getNamespaceURI();
        String localPart = name.getLocalName();
        if (prefix != null) {
            return new QName(ns, localPart, prefix);
        }
        return new QName(ns, localPart);
    }

    public static Iterable<XdmItem> axisIterable(final XdmNode node, final Axis axis) {
        return new Iterable<XdmItem>(){

            @Override
            public Iterator<XdmItem> iterator() {
                return node.axisIterator(axis);
            }
        };
    }

    public static XPathExpression compileExpression(String expression, Hashtable<String, String> namespaceBindings, Configuration configuration) throws XPathException {
        XPathEvaluator xpathEvaluator = new XPathEvaluator(configuration);
        xpathEvaluator.getStaticContext().setNamespaceResolver((NamespaceResolver)new MatchingNamespaceResolver(namespaceBindings));
        return xpathEvaluator.createPattern(expression);
    }

    public static boolean evaluateBoolean(XPathExpression expression, XdmNode contextNode) {
        try {
            XPathDynamicContext context = expression.createDynamicContext((Item)contextNode.getUnderlyingNode());
            return expression.effectiveBooleanValue(context);
        }
        catch (XPathException e) {
            return false;
        }
    }

    private SaxonHelper() {
    }

    public static class MatchingNamespaceResolver
    implements NamespaceResolver {
        private Hashtable<String, String> ns = new Hashtable();

        public MatchingNamespaceResolver(Hashtable<String, String> bindings) {
            this.ns = bindings;
        }

        public String getURIForPrefix(String prefix, boolean useDefault) {
            if ("".equals(prefix) && !useDefault) {
                return "";
            }
            return this.ns.get(prefix);
        }

        public Iterator<String> iteratePrefixes() {
            Vector<String> p = new Vector<String>();
            for (String pfx : this.ns.keySet()) {
                p.add(pfx);
            }
            return p.iterator();
        }
    }
}

