/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.daisy.common.saxon.SaxonConfigurator;
import org.daisy.common.saxon.impl.ProcessorImpl;
import org.daisy.common.spi.ServiceLoader;
import org.daisy.common.spi.ServiceWithProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorImpl_SPI
extends ProcessorImpl
implements ServiceWithProperties {
    private static final Logger spi_log = LoggerFactory.getLogger(ProcessorImpl_SPI.class);
    private final Map spi_props;
    private boolean spi_deactivated = false;

    public ProcessorImpl_SPI() {
        spi_log.trace("Creating ProcessorImpl");
        this.spi_props = new HashMap();
        this.spi_props.put("component.name", "saxon-processor");
        spi_log.trace("Binding org.daisy.common.saxon.SaxonConfigurator services...");
        int minRef = 1;
        int maxRef = 1;
        int refCount = 0;
        try {
            Iterator services = ServiceLoader.load(SaxonConfigurator.class).iterator();
            while (services.hasNext()) {
                try {
                    SaxonConfigurator service = (SaxonConfigurator)services.next();
                    this.setSaxonConfigurator(service);
                    spi_log.trace("Bound org.daisy.common.saxon.SaxonConfigurator service: " + service.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(service)));
                    if (maxRef <= 0 || ++refCount != maxRef) continue;
                    break;
                }
                catch (Throwable e) {
                    spi_log.error("Error while binding org.daisy.common.saxon.SaxonConfigurator service", e);
                }
            }
        }
        catch (Throwable e) {
            spi_log.error("Error while binding org.daisy.common.saxon.SaxonConfigurator services", e);
        }
        if (refCount < minRef) {
            spi_log.warn("No org.daisy.common.saxon.SaxonConfigurator found");
            throw new RuntimeException("No org.daisy.common.saxon.SaxonConfigurator found");
        }
        spi_log.trace("Bound " + refCount + " org.daisy.common.saxon.SaxonConfigurator services.");
        spi_log.trace("Activating ProcessorImpl");
        this.activate();
    }

    public void spi_deactivate() {
    }

    public Map spi_getProperties() {
        return this.spi_props;
    }
}

