/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon.xslt;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.URIResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;
import org.daisy.common.saxon.SaxonHelper;

public class ThreadUnsafeXslTransformer {
    private final XsltTransformer transformer;
    private final Processor processor;

    ThreadUnsafeXslTransformer(XsltTransformer transformer, Processor processor) {
        this.transformer = transformer;
        this.processor = processor;
    }

    public XdmNode transform(XdmNode xml) throws SaxonApiException {
        return this.transform(xml, null);
    }

    public String transformToString(XdmNode xml) throws SaxonApiException {
        return this.transformToString(xml, null);
    }

    public XdmNode transform(XdmNode xml, Map<String, Object> parameters) throws SaxonApiException {
        XdmDestination dest = new XdmDestination();
        this.genericTransform(xml, parameters, (Destination)dest);
        return dest.getXdmNode();
    }

    public String transformToString(XdmNode xml, Map<String, Object> parameters) throws SaxonApiException {
        Serializer dest = this.processor.newSerializer();
        StringWriter sw = new StringWriter();
        dest.setOutputWriter((Writer)sw);
        this.genericTransform(xml, parameters, (Destination)dest);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genericTransform(XdmNode input, Map<String, Object> parameters, Destination dest) throws SaxonApiException {
        try {
            if (parameters != null) {
                for (Map.Entry<String, Object> param : parameters.entrySet()) {
                    this.transformer.setParameter(new QName(null, param.getKey()), XdmValue.wrap((Sequence)SaxonHelper.sequenceFromObject(param.getValue())));
                }
            }
            this.transformer.setSource(input.asSource());
            this.transformer.setDestination(dest);
            this.transformer.transform();
        }
        finally {
            if (parameters != null) {
                for (Map.Entry<String, Object> param : parameters.entrySet()) {
                    this.transformer.setParameter(new QName(null, param.getKey()), null);
                }
            }
        }
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.transformer.setURIResolver(uriResolver);
    }
}

