/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xpath.saxon;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import net.sf.saxon.dom.DocumentBuilderImpl;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.saxon.SaxonOutputValue;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.xpath.saxon.ExtensionFunctionProvider;

public abstract class ReflexiveExtensionFunctionProvider
implements ExtensionFunctionProvider {
    private final List<ExtensionFunctionDefinition> definitions;

    @Override
    public Collection<ExtensionFunctionDefinition> getDefinitions() {
        return this.definitions;
    }

    protected ReflexiveExtensionFunctionProvider(Class<?> definition) {
        List<Executable> list;
        HashMap methods = new HashMap();
        for (Constructor<?> constructor : definition.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            list = (ArrayList)methods.get("new");
            if (list == null) {
                list = new ArrayList();
                methods.put("new", list);
            }
            list.add(constructor);
            methods.put("new", list);
        }
        for (Executable executable : definition.getDeclaredMethods()) {
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || "toString".equals(((Method)executable).getName()) && ((Method)executable).getParameterCount() == 0 && !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            list = (List)methods.get(((Method)executable).getName());
            if (list == null) {
                list = new ArrayList();
                methods.put(((Method)executable).getName(), list);
            }
            list.add(executable);
            methods.put(((Method)executable).getName(), list);
        }
        this.definitions = new ArrayList<ExtensionFunctionDefinition>();
        for (List m : methods.values()) {
            Collections.sort(m, (a, b) -> new Integer(a.getParameterCount()).compareTo(b.getParameterCount()));
            this.definitions.add(this.extensionFunctionDefinitionFromMethods(m));
        }
    }

    private ExtensionFunctionDefinition extensionFunctionDefinitionFromMethods(Collection<Executable> methods) throws IllegalArgumentException {
        ExtensionFunctionDefinition ret = null;
        for (Executable m : methods) {
            ExtensionFunctionDefinition def = this.extensionFunctionDefinitionFromMethod(m);
            if (ret == null) {
                ret = def;
                continue;
            }
            final ExtensionFunctionDefinition defA = ret;
            final ExtensionFunctionDefinition defB = def;
            final StructuredQName funcName = defA.getFunctionQName();
            if (!defB.getFunctionQName().equals((Object)funcName)) {
                throw new IllegalArgumentException();
            }
            final SequenceType[] argTypes = defB.getArgumentTypes();
            if (defB.getMinimumNumberOfArguments() <= defA.getMaximumNumberOfArguments() || !Arrays.equals(Arrays.copyOfRange(argTypes, 0, defA.getArgumentTypes().length), defA.getArgumentTypes())) {
                if (m instanceof Constructor) {
                    throw new IllegalArgumentException("Incompatible constructors");
                }
                throw new IllegalArgumentException("Incompatible '" + m.getName() + "' methods");
            }
            final int minArgs = defA.getMinimumNumberOfArguments();
            final int maxArgs = defB.getMaximumNumberOfArguments();
            ret = new ExtensionFunctionDefinition(){

                public StructuredQName getFunctionQName() {
                    return funcName;
                }

                public int getMinimumNumberOfArguments() {
                    return minArgs;
                }

                public int getMaximumNumberOfArguments() {
                    return maxArgs;
                }

                public SequenceType[] getArgumentTypes() {
                    return argTypes;
                }

                public SequenceType getResultType(SequenceType[] suppliedArgTypes) {
                    if (suppliedArgTypes.length >= defB.getMinimumNumberOfArguments()) {
                        return defB.getResultType(suppliedArgTypes);
                    }
                    if (suppliedArgTypes.length <= defA.getMaximumNumberOfArguments()) {
                        return defA.getResultType(suppliedArgTypes);
                    }
                    throw new IllegalArgumentException("Function " + funcName + " can not be called with " + suppliedArgTypes.length + " arguments");
                }

                public ExtensionFunctionCall makeCallExpression() {
                    return new ExtensionFunctionCall(){
                        ExtensionFunctionCall callA = null;
                        ExtensionFunctionCall callB = null;

                        public Sequence call(XPathContext ctxt, Sequence[] args) throws XPathException {
                            if (args.length <= defA.getMaximumNumberOfArguments()) {
                                if (this.callA == null) {
                                    this.callA = defA.makeCallExpression();
                                }
                                return this.callA.call(ctxt, args);
                            }
                            if (args.length >= defB.getMinimumNumberOfArguments()) {
                                if (this.callB == null) {
                                    this.callB = defB.makeCallExpression();
                                }
                                return this.callB.call(ctxt, args);
                            }
                            throw new IllegalArgumentException("Function " + funcName + " can not be called with " + args.length + " arguments");
                        }
                    };
                }
            };
        }
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private ExtensionFunctionDefinition extensionFunctionDefinitionFromMethod(final Executable method) throws IllegalArgumentException {
        void var12_18;
        assert (method instanceof Constructor || method instanceof Method);
        if (method.isVarArgs()) {
            throw new IllegalArgumentException();
        }
        final Class<?> declaringClass = method.getDeclaringClass();
        boolean isInnerClass = Arrays.stream(this.getClass().getClasses()).anyMatch(declaringClass::equals) && !Modifier.isStatic(declaringClass.getModifiers());
        final boolean isConstructor = method instanceof Constructor;
        boolean isStatic = isConstructor || Modifier.isStatic(method.getModifiers());
        boolean requiresXMLStreamWriter = false;
        boolean requiresXPath = false;
        boolean requiresDocumentBuilder = false;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (clazz.equals(XPath.class)) {
                if (requiresXPath) {
                    throw new IllegalArgumentException();
                }
                requiresXPath = true;
                continue;
            }
            if (clazz.equals(DocumentBuilder.class)) {
                if (requiresDocumentBuilder) {
                    throw new IllegalArgumentException();
                }
                requiresDocumentBuilder = true;
                continue;
            }
            if (!clazz.equals(XMLStreamWriter.class)) continue;
            if (requiresXMLStreamWriter) {
                throw new IllegalArgumentException();
            }
            requiresXMLStreamWriter = true;
        }
        Type[] types = method.getGenericParameterTypes();
        Type[] javaArgumentTypes = isConstructor && isInnerClass ? Arrays.copyOfRange(types, 1, types.length) : types;
        final SequenceType[] argumentTypes = new SequenceType[javaArgumentTypes.length + (isStatic ? 0 : 1) - (requiresXMLStreamWriter ? 1 : 0) - (requiresXPath ? 1 : 0) - (requiresDocumentBuilder ? 1 : 0)];
        int i = 0;
        if (!isStatic) {
            argumentTypes[i++] = SequenceType.SINGLE_ITEM;
        }
        for (Type t : javaArgumentTypes) {
            if (t.equals(XMLStreamWriter.class) || t.equals(XPath.class) || t.equals(DocumentBuilder.class)) continue;
            argumentTypes[i++] = SaxonHelper.sequenceTypeFromType(t);
        }
        if (isConstructor) {
            if (requiresXMLStreamWriter) {
                throw new IllegalArgumentException();
            }
            SequenceType sequenceType = SequenceType.SINGLE_ITEM;
        } else {
            Type t = ((Method)method).getGenericReturnType();
            if (requiresXMLStreamWriter) {
                if (!t.equals(Void.TYPE)) {
                    throw new IllegalArgumentException();
                }
                SequenceType sequenceType = SequenceType.NODE_SEQUENCE;
            } else {
                SequenceType sequenceType = SaxonHelper.sequenceTypeFromType(t);
            }
        }
        return new ExtensionFunctionDefinition((SequenceType)var12_18, isStatic, isInnerClass, javaArgumentTypes){
            final /* synthetic */ SequenceType val$resultType;
            final /* synthetic */ boolean val$isStatic;
            final /* synthetic */ boolean val$isInnerClass;
            final /* synthetic */ Type[] val$javaArgumentTypes;
            {
                this.val$resultType = sequenceType;
                this.val$isStatic = bl2;
                this.val$isInnerClass = bl3;
                this.val$javaArgumentTypes = typeArray;
            }

            public SequenceType[] getArgumentTypes() {
                return argumentTypes;
            }

            public StructuredQName getFunctionQName() {
                return new StructuredQName(declaringClass.getSimpleName(), declaringClass.getName(), isConstructor ? "new" : method.getName());
            }

            public SequenceType getResultType(SequenceType[] suppliedArgTypes) {
                return this.val$resultType;
            }

            public ExtensionFunctionCall makeCallExpression() {
                return new ExtensionFunctionCall(){

                    public Sequence call(XPathContext ctxt, Sequence[] args) throws XPathException {
                        try {
                            Object result;
                            if (args.length != argumentTypes.length) {
                                throw new IllegalArgumentException();
                            }
                            int i = 0;
                            Object instance = null;
                            if (!val$isStatic) {
                                Item item2 = SaxonHelper.getSingleItem(args[i++]);
                                try {
                                    instance = SaxonHelper.objectFromItem(item2, declaringClass);
                                }
                                catch (IllegalArgumentException e) {
                                    throw new IllegalArgumentException("Expected ObjectValue<" + declaringClass.getSimpleName() + ">, but got: " + item2, e);
                                }
                            }
                            ArrayList nodeListFromXMLStreamWriter = null;
                            Object[] javaArgs = new Object[method.getParameterCount()];
                            int j = 0;
                            if (isConstructor && val$isInnerClass) {
                                javaArgs[j++] = ReflexiveExtensionFunctionProvider.this;
                            }
                            for (Type type : val$javaArgumentTypes) {
                                Optional<Item> item3;
                                if (type.equals(XMLStreamWriter.class)) {
                                    ArrayList list;
                                    nodeListFromXMLStreamWriter = list = new ArrayList();
                                    BaseURIAwareXMLStreamWriter xmlStreamWriterArg = new SaxonOutputValue(item -> {
                                        if (!(item instanceof XdmNode)) {
                                            throw new RuntimeException();
                                        }
                                        list.add(((XdmNode)item).getUnderlyingNode());
                                    }, ctxt.getConfiguration()).asXMLStreamWriter();
                                    javaArgs[j++] = xmlStreamWriterArg;
                                    continue;
                                }
                                if (type.equals(XPath.class)) {
                                    javaArgs[j++] = new XPathFactoryImpl(ctxt.getConfiguration()).newXPath();
                                    continue;
                                }
                                if (type.equals(DocumentBuilder.class)) {
                                    DocumentBuilderImpl b = new DocumentBuilderImpl();
                                    b.setConfiguration(ctxt.getConfiguration());
                                    javaArgs[j++] = b;
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Iterator.class)) {
                                    javaArgs[j++] = SaxonHelper.iteratorFromSequence(args[i++], ((ParameterizedType)type).getActualTypeArguments()[0]);
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Iterable.class)) {
                                    javaArgs[j++] = SaxonHelper.iterableFromSequence(args[i++], ((ParameterizedType)type).getActualTypeArguments()[0]);
                                    continue;
                                }
                                if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Optional.class)) {
                                    item3 = SaxonHelper.getOptionalItem(args[i++]);
                                    javaArgs[j++] = item3.isPresent() ? Optional.of(SaxonHelper.objectFromItem(item3.get(), ((ParameterizedType)type).getActualTypeArguments()[0])) : Optional.empty();
                                    continue;
                                }
                                if (type.equals(URI.class)) {
                                    if (!(item3 = SaxonHelper.getOptionalItem(args[i++])).isPresent()) {
                                        throw new IllegalArgumentException("Expected xs:anyURI but got an empty sequence");
                                    }
                                    javaArgs[j++] = SaxonHelper.objectFromItem(item3.get(), type);
                                    continue;
                                }
                                javaArgs[j++] = SaxonHelper.objectFromItem(SaxonHelper.getSingleItem(args[i++]), type);
                            }
                            try {
                                result = isConstructor ? ((Constructor)method).newInstance(javaArgs) : ((Method)method).invoke(instance, javaArgs);
                            }
                            catch (InstantiationException | InvocationTargetException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof XPathException) {
                                    throw (XPathException)cause;
                                }
                                if (cause instanceof TransformerException) {
                                    XPathException xpe = new XPathException(cause.getMessage(), cause.getCause());
                                    QName code = ((TransformerException)cause).getCode();
                                    xpe.setErrorCodeQName(new StructuredQName(code.getPrefix(), code.getNamespaceURI(), code.getLocalPart()));
                                    throw xpe;
                                }
                                throw new XPathException(cause);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException();
                            }
                            if (nodeListFromXMLStreamWriter != null) {
                                return new SequenceExtent(nodeListFromXMLStreamWriter);
                            }
                            if (result instanceof Optional) {
                                return SaxonHelper.sequenceFromObject(((Optional)result).orElse(null));
                            }
                            return SaxonHelper.sequenceFromObject(result);
                        }
                        catch (RuntimeException e) {
                            throw new XPathException("Unexpected error in " + this.getFunctionQName().getClarkName(), (Throwable)e);
                        }
                    }
                };
            }
        };
    }
}

