/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.SignatureException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.clients.RequestLog;
import org.daisy.pipeline.clients.RequestLogEntry;
import org.daisy.pipeline.webservice.impl.SimpleRequestLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator {
    private static Logger logger = LoggerFactory.getLogger((String)Authenticator.class.getName());
    private RequestLog requestLog;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public Authenticator(RequestLog requestLog) {
        this.requestLog = requestLog;
    }

    public boolean authenticate(Client client, String hash, String timestamp, String nonce, String URI2, long maxRequestTime) {
        int idx = URI2.indexOf("&sign=", 0);
        if (idx > 1) {
            String hashuri = URI2.substring(0, idx);
            String clientSecret = client.getSecret();
            String serverHash = "";
            try {
                Date clientTimestamp;
                serverHash = Authenticator.calculateRFC2104HMAC(hashuri, clientSecret);
                SimpleDateFormat UTC_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                UTC_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date serverTimestamp = new Date(System.currentTimeMillis());
                try {
                    clientTimestamp = UTC_FORMATTER.parse(timestamp);
                }
                catch (ParseException e) {
                    logger.error(String.format("Could not parse timestamp: %s", timestamp));
                    e.printStackTrace();
                    return false;
                }
                if (!hash.equals(serverHash)) {
                    logger.error("Hash values do not match");
                    return false;
                }
                if (serverTimestamp.getTime() - clientTimestamp.getTime() > maxRequestTime) {
                    logger.error("Request expired");
                    return false;
                }
                if (!this.checkValidNonce(client, nonce, timestamp)) {
                    logger.error("Invalid nonce");
                    return false;
                }
                return true;
            }
            catch (SignatureException e) {
                logger.error("Could not generate hash");
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static URI createUriWithCredentials(String uri, Client client) {
        String uristring = "";
        String timestamp = Authenticator.getCurrentTimestamp();
        String nonce = Authenticator.generateNonce();
        String params = "authid=%s&time=%s&nonce=%s";
        params = String.format(params, client.getId(), timestamp, nonce);
        uristring = uri.indexOf("?") == -1 ? uri + "?" + params : uri + "&" + params;
        URI newUri = null;
        try {
            String hash = Authenticator.calculateRFC2104HMAC(uristring, client.getSecret());
            String authUri = uristring + "&sign=" + hash;
            newUri = new URI(authUri);
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return newUri;
    }

    private boolean checkValidNonce(Client client, String nonce, String timestamp) {
        if (client == null) {
            throw new IllegalArgumentException("Client is null");
        }
        SimpleRequestLogEntry entry = new SimpleRequestLogEntry(client.getId(), nonce, timestamp);
        if (this.requestLog.contains((RequestLogEntry)entry)) {
            logger.warn("Duplicate nonce detected.");
            return false;
        }
        this.requestLog.add((RequestLogEntry)entry);
        return true;
    }

    private static String calculateRFC2104HMAC(String data, String secret) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingSecret = new SecretKeySpec(secret.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingSecret);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    private static String generateNonce() {
        long range = (long)Math.pow(10.0, 30.0);
        long num = (long)(new Random().nextDouble() * (double)range);
        String nonce = String.format("%-30d", num).replace(' ', '0');
        return nonce;
    }

    private static String getCurrentTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String now = dateFormat.format(new Date()) + 'Z';
        return now;
    }
}

