/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice;

import java.io.File;
import org.daisy.pipeline.webservice.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineWebServiceConfiguration {
    private boolean usesAuthentication = false;
    private long maxRequestTime = 600000L;
    private String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
    private boolean ssl = false;
    private String sslKeystore = "";
    private String sslKeystorePassword = "";
    private String sslKeyPassword = "";
    private String clientKey = null;
    private String clientSecret = null;
    private static Logger logger = LoggerFactory.getLogger(PipelineWebServiceConfiguration.class);
    private boolean cleanUpOnStartUp = false;

    public PipelineWebServiceConfiguration() {
        this.readOptions();
    }

    private void readOptions() {
        String maxrequesttime;
        String tmp;
        String authentication = Properties.AUTHENTICATION.get();
        if (authentication != null) {
            if (authentication.equalsIgnoreCase("true")) {
                this.usesAuthentication = true;
            } else if (authentication.equalsIgnoreCase("false")) {
                this.usesAuthentication = false;
                logger.info("Web service authentication is OFF");
            } else {
                logger.error(String.format("Value specified in option %s (%s) is not valid. Using default value of %s.", new Object[]{Properties.AUTHENTICATION, authentication, this.usesAuthentication}));
            }
        }
        if ((tmp = Properties.TMPDIR.get()) != null) {
            File f = new File(tmp);
            if (f.exists()) {
                this.tmpDir = tmp;
            } else {
                logger.error(String.format("Value specified in option %s (%s) is not valid. Using default value of %s.", new Object[]{Properties.TMPDIR, tmp, this.tmpDir}));
            }
        }
        if ((maxrequesttime = Properties.MAX_REQUEST_TIME.get()) != null) {
            try {
                long ms;
                this.maxRequestTime = ms = Long.parseLong(maxrequesttime);
            }
            catch (NumberFormatException e) {
                logger.error(String.format("Value specified in option %s (%s) is not a valid numeric value. Using default value of %d.", new Object[]{Properties.MAX_REQUEST_TIME, maxrequesttime, this.maxRequestTime}));
            }
        }
        this.ssl = Properties.SSL.get() != null && Properties.SSL.get().equalsIgnoreCase("true");
        this.sslKeystore = Properties.SSL_KEYSTORE.get("");
        this.sslKeystorePassword = Properties.SSL_KEYSTOREPASSWORD.get("");
        this.sslKeyPassword = Properties.SSL_KEYPASSWORD.get("");
        this.clientKey = Properties.CLIENT_KEY.get();
        this.clientSecret = Properties.CLIENT_SECRET.get();
        this.cleanUpOnStartUp = Boolean.valueOf(Properties.CLEAN_UP_ON_START_UP.get("false"));
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean isAuthenticationEnabled() {
        return this.usesAuthentication;
    }

    public boolean isLocalFS() {
        return Boolean.valueOf(Properties.LOCALFS.get("false"));
    }

    public long getMaxRequestTime() {
        return this.maxRequestTime;
    }

    public boolean getCleanUpOnStartUp() {
        return this.cleanUpOnStartUp;
    }
}

