/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.impl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.daisy.common.messaging.Message;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.webservice.Authenticator;
import org.daisy.pipeline.webservice.Callback;
import org.daisy.pipeline.webservice.xml.JobXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PosterCallback
extends Callback {
    private final URI url;
    private final Client client;
    private final String requestRootUrl;
    private static Logger logger = LoggerFactory.getLogger((String)PosterCallback.class.getName());

    public PosterCallback(Job job, Callback.CallbackType type, int frequency, URI url, Client client, String requestRootUrl) {
        super(job, type, frequency, 0);
        this.url = url;
        this.client = client;
        this.requestRootUrl = requestRootUrl;
    }

    @Override
    public boolean postMessages(List<Message> messages, int newerThan, BigDecimal progress) {
        logger.debug("Posting messages to " + this.url);
        JobXmlWriter writer = new JobXmlWriter(this.getJob(), this.requestRootUrl);
        writer.withMessages(messages, newerThan);
        writer.withProgress(progress);
        Document doc = writer.getXmlDocument();
        return PosterCallback.postXml(doc, this.url, this.client);
    }

    @Override
    public boolean postStatusUpdate(Job.Status status) {
        logger.debug("Posting status '" + status + "' to " + this.url);
        JobXmlWriter writer = new JobXmlWriter(this.getJob(), this.requestRootUrl);
        writer.overwriteStatus(status);
        Document doc = writer.getXmlDocument();
        return PosterCallback.postXml(doc, this.url, this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean postXml(Document doc, URI url, Client client) {
        URI requestUri = url;
        if (client != null) {
            requestUri = Authenticator.createUriWithCredentials(url.toString(), client);
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)requestUri.toURL().openConnection();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            logger.error(e.getMessage());
            return false;
        }
        try {
            connection.connect();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        DataOutputStream output = null;
        try {
            output = new DataOutputStream(connection.getOutputStream());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        try {
            logger.debug("Posting XML: " + XmlUtils.nodeToString(doc));
            output.writeBytes(XmlUtils.nodeToString(doc));
            output.flush();
            output.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        try {
            logger.debug("Got response: " + connection.getResponseMessage() + " (" + connection.getResponseCode() + ")");
            try (DataInputStream input2 = new DataInputStream(connection.getInputStream());){
                logger.debug(new BufferedReader(new InputStreamReader(input2)).lines().collect(Collectors.joining("\n")));
            }
            catch (Exception input2) {
                // empty catch block
            }
            return true;
        }
        catch (IOException e) {
            logger.warn("No response");
            logger.debug("No response", (Throwable)e);
            return false;
        }
    }
}

