/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.impl;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.daisy.common.messaging.MessageAccessor;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobManagerFactory;
import org.daisy.pipeline.job.JobMonitor;
import org.daisy.pipeline.job.StatusNotifier;
import org.daisy.pipeline.webservice.Callback;
import org.daisy.pipeline.webservice.CallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushNotifier
implements CallbackHandler {
    private JobManager jobManager;
    private Map<JobId, List<Callback>> callbacks;
    private Map<MessageAccessor, JobId> jobForAccessor;
    private Map<MessageAccessor, Runnable> unlistenMessagesFunctions;
    private Map<StatusNotifier, Runnable> unlistenStatusFunctions;
    private static Logger logger = LoggerFactory.getLogger(PushNotifier.class);
    final int PUSH_INTERVAL = 1000;
    private Map<Callback, Integer> lastPushedMessage = new HashMap<Callback, Integer>();
    private Map<MessageAccessor, Integer> lastUnpushedMessage = Collections.synchronizedMap(new HashMap());
    private Map<JobId, Job.Status> lastUnpushedStatus = Collections.synchronizedMap(new HashMap());
    private Timer timer = null;

    public PushNotifier(JobManagerFactory jobManagerFactory) {
        logger.debug("Activating push notifier");
        this.jobManager = jobManagerFactory.create();
        this.callbacks = new HashMap<JobId, List<Callback>>();
        this.jobForAccessor = Collections.synchronizedMap(new HashMap());
        this.unlistenMessagesFunctions = new HashMap<MessageAccessor, Runnable>();
        this.unlistenStatusFunctions = new HashMap<StatusNotifier, Runnable>();
        this.startTimer();
    }

    public void close() {
        this.cancelTimer();
    }

    private synchronized void startTimer() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new NotifyTask(), 0L, 1000L);
    }

    private synchronized void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(Callback callback) {
        logger.debug("Adding callback: " + callback);
        Map<JobId, List<Callback>> map = this.callbacks;
        synchronized (map) {
            Job job = callback.getJob();
            List<Callback> list = this.callbacks.get(job.getId());
            if (list == null) {
                list = new ArrayList<Callback>();
                this.callbacks.put(job.getId(), Collections.synchronizedList(list));
            }
            switch (callback.getType()) {
                case STATUS: {
                    Job.Status status = job.getStatus();
                    this.lastUnpushedStatus.put(job.getId(), status);
                    if (status == Job.Status.SUCCESS || status == Job.Status.ERROR || status == Job.Status.FAIL) break;
                    boolean alreadyListening = false;
                    for (Callback c : list) {
                        if (c.getType() != Callback.CallbackType.STATUS) continue;
                        alreadyListening = true;
                        break;
                    }
                    if (alreadyListening) break;
                    JobMonitor monitor = job.getMonitor();
                    StatusNotifier statusNotifier = monitor.getStatusUpdates();
                    Consumer<Job.Status> statusListener = s -> this.update(job.getId(), (Job.Status)s);
                    statusNotifier.listen(statusListener);
                    this.unlistenStatusFunctions.put(statusNotifier, () -> statusNotifier.unlisten(statusListener));
                    break;
                }
                case MESSAGES: {
                    Job.Status status = job.getStatus();
                    if (status == Job.Status.SUCCESS || status == Job.Status.ERROR || status == Job.Status.FAIL) {
                        this.lastUnpushedMessage.put(job.getMonitor().getMessageAccessor(), Integer.MAX_VALUE);
                        break;
                    }
                    boolean alreadyListening = false;
                    for (Callback c : list) {
                        if (c.getType() != Callback.CallbackType.MESSAGES) continue;
                        alreadyListening = true;
                        break;
                    }
                    if (alreadyListening) break;
                    JobMonitor monitor = job.getMonitor();
                    MessageAccessor accessor = monitor.getMessageAccessor();
                    this.jobForAccessor.put(accessor, job.getId());
                    Consumer<Integer> messageListener = i -> this.update(accessor, (Integer)i);
                    accessor.listen(messageListener);
                    this.unlistenMessagesFunctions.put(accessor, () -> accessor.unlisten(messageListener));
                    break;
                }
            }
            list.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallback(Callback callback) {
        Map<JobId, List<Callback>> map = this.callbacks;
        synchronized (map) {
            Job job = callback.getJob();
            List<Callback> list = this.callbacks.get(job.getId());
            if (list == null || !list.remove(callback)) {
                return;
            }
            boolean keepListeningForMessages = false;
            boolean keepListeningForStatusUpdates = false;
            for (Callback c : list) {
                if (c.getType() == Callback.CallbackType.MESSAGES) {
                    keepListeningForMessages = true;
                } else {
                    keepListeningForStatusUpdates = true;
                }
                if (!keepListeningForMessages || !keepListeningForStatusUpdates) continue;
                break;
            }
            if (!keepListeningForMessages || !keepListeningForStatusUpdates) {
                Runnable unlistenStatus;
                JobMonitor monitor = job.getMonitor();
                if (!keepListeningForMessages) {
                    MessageAccessor accessor = monitor.getMessageAccessor();
                    this.jobForAccessor.remove(accessor);
                    Runnable unlistenMessages = this.unlistenMessagesFunctions.remove(accessor);
                    if (unlistenMessages != null) {
                        unlistenMessages.run();
                    }
                }
                if (!keepListeningForStatusUpdates && (unlistenStatus = this.unlistenStatusFunctions.remove(monitor.getStatusUpdates())) != null) {
                    unlistenStatus.run();
                }
            }
            if (list.isEmpty()) {
                this.callbacks.remove(job.getId());
            }
            Map<Callback, Integer> map2 = this.lastPushedMessage;
            synchronized (map2) {
                this.lastPushedMessage.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlistenJob(JobId jobId) {
        Map<JobId, List<Callback>> map = this.callbacks;
        synchronized (map) {
            Runnable unlistenStatus;
            List<Callback> callbacks = this.callbacks.remove(jobId);
            if (callbacks == null || callbacks.isEmpty()) {
                return;
            }
            Job job = null;
            Iterator<Callback> iterator = callbacks.iterator();
            if (iterator.hasNext()) {
                Callback c = iterator.next();
                job = c.getJob();
            }
            JobMonitor monitor = job.getMonitor();
            MessageAccessor accessor = monitor.getMessageAccessor();
            this.jobForAccessor.remove(accessor);
            Runnable unlistenMessages = this.unlistenMessagesFunctions.remove(accessor);
            if (unlistenMessages != null) {
                unlistenMessages.run();
            }
            if ((unlistenStatus = this.unlistenStatusFunctions.remove(monitor.getStatusUpdates())) != null) {
                unlistenStatus.run();
            }
            Map<Callback, Integer> map2 = this.lastPushedMessage;
            synchronized (map2) {
                for (Callback c : callbacks) {
                    this.lastPushedMessage.remove(c);
                }
            }
        }
    }

    private void update(MessageAccessor accessor, Integer sequence) {
        logger.trace("handling message update: [job: " + this.jobForAccessor.get(accessor) + ", event: " + sequence + "]");
        this.lastUnpushedMessage.put(accessor, sequence);
    }

    private void update(JobId job, Job.Status status) {
        logger.debug(String.format("Status changed %s->%s", job, status));
        this.lastUnpushedStatus.put(job, status);
    }

    private class NotifyTask
    extends TimerTask {
        private Set<JobId> finishedJobs = new HashSet<JobId>();

        @Override
        public synchronized void run() {
            for (JobId j : this.finishedJobs) {
                PushNotifier.this.unlistenJob(j);
            }
            this.finishedJobs.clear();
            this.postMessages();
            this.postStatus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postStatus() {
            HashMap lastUnpushedStatus;
            Map map = PushNotifier.this.lastUnpushedStatus;
            synchronized (map) {
                lastUnpushedStatus = new HashMap(PushNotifier.this.lastUnpushedStatus);
                PushNotifier.this.lastUnpushedStatus.clear();
            }
            for (JobId job : lastUnpushedStatus.keySet()) {
                ArrayList callbacks;
                Job.Status status = (Job.Status)lastUnpushedStatus.get(job);
                logger.debug("Posting status '" + status + "' for job " + job);
                Map map2 = PushNotifier.this.callbacks;
                synchronized (map2) {
                    callbacks = (ArrayList)PushNotifier.this.callbacks.get(job);
                    if (callbacks != null) {
                        callbacks = new ArrayList(callbacks);
                    }
                }
                if (callbacks != null) {
                    for (Callback callback : callbacks) {
                        if (callback.getType() != Callback.CallbackType.STATUS) continue;
                        callback.postStatusUpdate(status);
                    }
                }
                if (status != Job.Status.SUCCESS && status != Job.Status.ERROR && status != Job.Status.FAIL && PushNotifier.this.jobManager.getJob(job).isPresent()) continue;
                this.finishedJobs.add(job);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void postMessages() {
            HashMap lastUnpushedMessage;
            Map map = PushNotifier.this.lastUnpushedMessage;
            synchronized (map) {
                lastUnpushedMessage = new HashMap(PushNotifier.this.lastUnpushedMessage);
                PushNotifier.this.lastUnpushedMessage.clear();
            }
            for (MessageAccessor accessor : lastUnpushedMessage.keySet()) {
                Optional j;
                ArrayList callbacks;
                JobId job = (JobId)PushNotifier.this.jobForAccessor.get(accessor);
                Map map2 = PushNotifier.this.callbacks;
                synchronized (map2) {
                    callbacks = (ArrayList)PushNotifier.this.callbacks.get(job);
                    if (callbacks != null) {
                        callbacks = new ArrayList(callbacks);
                    }
                }
                if (callbacks != null) {
                    BigDecimal progress = accessor.getProgress();
                    int to = (Integer)lastUnpushedMessage.get(accessor);
                    if (to > 0) {
                        --to;
                    }
                    HashMap<Integer, List> messagesFrom = new HashMap<Integer, List>();
                    for (Callback callback : callbacks) {
                        if (callback.getType() != Callback.CallbackType.MESSAGES) continue;
                        int from = PushNotifier.this.lastPushedMessage.containsKey(callback) ? (Integer)PushNotifier.this.lastPushedMessage.get(callback) + 1 : callback.getFirstMessage();
                        List messages = (List)messagesFrom.get(from);
                        if (messages == null) {
                            if (to >= from) {
                                logger.debug("Posting messages starting from " + from + " for job " + job);
                                messages = accessor.createFilter().inRange(from, to).getMessages();
                            } else {
                                messages = Collections.emptyList();
                            }
                            messagesFrom.put(from, messages);
                        }
                        callback.postMessages(messages, from - 1, progress);
                        PushNotifier.this.lastPushedMessage.put(callback, to);
                    }
                }
                if (!(j = PushNotifier.this.jobManager.getJob(job)).isPresent()) {
                    this.finishedJobs.add(job);
                    continue;
                }
                Job.Status status = ((Job)j.get()).getStatus();
                if (status != Job.Status.SUCCESS && status != Job.Status.ERROR && status != Job.Status.FAIL) continue;
                this.finishedJobs.add(job);
            }
        }
    }
}

