/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.clients.ClientStorage;
import org.daisy.pipeline.webservice.impl.VolatileClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileClientStorage
implements ClientStorage {
    static final VolatileClient DEFAULT = new VolatileClient("DEFAULT_VOLATILE_CLIENT_7333298", "", Client.Role.ADMIN, "", Priority.MEDIUM);
    private static Logger logger = LoggerFactory.getLogger(VolatileClientStorage.class);
    private Map<String, Client> clients = Collections.synchronizedMap(new HashMap());

    public List<? extends Client> getAll() {
        return Collections.unmodifiableList(new LinkedList<Client>(this.clients.values()));
    }

    public Optional<Client> get(String id) {
        if (DEFAULT.getId().equals(id)) {
            return Optional.of((Object)DEFAULT);
        }
        Client c = this.clients.get(id);
        return Optional.fromNullable((Object)c);
    }

    public boolean delete(String id) {
        return this.clients.remove(id) != null;
    }

    private Client add(Client client) {
        if (client.getId().equals(DEFAULT.getId()) || this.clients.containsKey(client.getId())) {
            return null;
        }
        this.clients.put(client.getId(), client);
        return client;
    }

    public Optional<Client> addClient(String id, String secret, Client.Role role, String contactInfo, Priority priority) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Client id can't be null");
        VolatileClient cli = new VolatileClient(id, secret, role, contactInfo, priority);
        return Optional.fromNullable((Object)this.add(cli));
    }

    public Optional<Client> addClient(String id, String secret, Client.Role role, String contactInfo) {
        return this.addClient(id, secret, role, contactInfo, Priority.MEDIUM);
    }

    public Client defaultClient() {
        return DEFAULT;
    }

    public Optional<Client> update(String id, String secret, Client.Role role, String contactInfo, Priority priority) {
        if (DEFAULT.getId().equals(id)) {
            return Optional.absent();
        }
        Optional<Client> toUpdate = this.get(id);
        if (!toUpdate.isPresent()) {
            return Optional.absent();
        }
        VolatileClient vol = (VolatileClient)toUpdate.get();
        vol.setSecret(secret);
        vol.setRole(role);
        vol.setContactInfo(contactInfo);
        vol.setPriority(priority);
        return Optional.of((Object)vol);
    }
}

