/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet;

import com.google.common.base.Optional;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.clients.RequestLog;
import org.daisy.pipeline.webservice.Authenticator;
import org.daisy.pipeline.webservice.restlet.GenericResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticatedResource
extends GenericResource {
    private static Logger logger = LoggerFactory.getLogger((String)Authenticator.class.getName());
    private boolean isAuthenticated = false;
    private Client client;

    public void doInit() {
        super.doInit();
        if (!this.getConfiguration().isAuthenticationEnabled()) {
            this.client = this.getStorage().getClientStorage().defaultClient();
            this.isAuthenticated = true;
        } else {
            this.isAuthenticated = this.authenticate();
        }
    }

    private boolean authenticate() {
        long maxRequestTime = this.getConfiguration().getMaxRequestTime();
        String authid = this.getQuery().getFirstValue("authid");
        Optional optionalClient = this.getStorage().getClientStorage().get(authid);
        if (!optionalClient.isPresent()) {
            logger.error(String.format("Client with auth ID '%s' not found", authid));
            return false;
        }
        this.client = (Client)optionalClient.get();
        RequestLog requestLog = this.getStorage().getRequestLog();
        return new Authenticator(requestLog).authenticate(this.client, this.getQuery().getFirstValue("sign"), this.getQuery().getFirstValue("time"), this.getQuery().getFirstValue("nonce"), this.getReference().toString(), maxRequestTime);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public Client getClient() {
        return this.client;
    }
}

