/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.clients.WebserviceStorage;
import org.daisy.pipeline.datatypes.DatatypeRegistry;
import org.daisy.pipeline.job.JobBatchId;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.script.ScriptRegistry;
import org.daisy.pipeline.webservice.CallbackHandler;
import org.daisy.pipeline.webservice.PipelineWebServiceConfiguration;
import org.daisy.pipeline.webservice.Properties;
import org.daisy.pipeline.webservice.restlet.impl.PipelineWebService;
import org.daisy.pipeline.webservice.xml.ErrorWriter;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericResource
extends ServerResource {
    private static Logger logger = LoggerFactory.getLogger(GenericResource.class);
    private static boolean shouldEnableCORS = Properties.CORS.get("false").equalsIgnoreCase("true");

    public PipelineWebServiceConfiguration getConfiguration() {
        return this.webservice().getConfiguration();
    }

    public WebserviceStorage getStorage() {
        return this.webservice().getStorage();
    }

    public JobManager getJobManager(Client client) {
        return this.webservice().getJobManager(client);
    }

    public JobManager getJobManager(Client client, JobBatchId batchId) {
        return this.webservice().getJobManager(client, batchId);
    }

    public ScriptRegistry getScriptRegistry() {
        return this.webservice().getScriptRegistry();
    }

    public DatatypeRegistry getDatatypeRegistry() {
        return this.webservice().getDatatypeRegistry();
    }

    public CallbackHandler getCallbackHandler() {
        return this.webservice().getCallbackHandler();
    }

    public boolean shutDown(long key) {
        return this.webservice().shutDown(key);
    }

    private PipelineWebService webservice() {
        return (PipelineWebService)this.getApplication();
    }

    protected Representation getErrorRepresentation(Throwable error) {
        logger.debug(null, error);
        ErrorWriter.ErrorWriterBuilder builder = new ErrorWriter.ErrorWriterBuilder().withError(error).withUri(this.getStatus().getUri());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, builder.build().getXmlDocument());
        this.logResponse(dom);
        return dom;
    }

    protected Representation getErrorRepresentation(String error) {
        logger.debug(error);
        ErrorWriter.ErrorWriterBuilder builder = new ErrorWriter.ErrorWriterBuilder().withError(new Throwable(error)).withUri(this.getStatus().getUri());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, builder.build().getXmlDocument());
        this.logResponse(dom);
        return dom;
    }

    public void doCatch(Throwable e) {
        logger.debug(null, e);
        super.doCatch(e);
    }

    public void setStatus(Status status) {
        this.logStatus(status);
        super.setStatus(status);
    }

    protected void logResponse(DomRepresentation dom) {
        if (logger.isDebugEnabled()) {
            try {
                StringWriter w = new StringWriter();
                dom.write((Writer)w);
                logger.debug(w.getBuffer().toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void logRequest() {
        Request req = this.getRequest();
        logger.debug(req.getMethod() + " " + req.getResourceRef().getPath());
    }

    private void logStatus(Status status) {
        logger.debug(status.toString());
    }

    protected void addWarningHeader(int code, String description) {
        Series headers = (Series)this.getResponse().getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            this.getResponse().getAttributes().put("org.restlet.http.headers", headers);
        }
        headers.add((Object)new Header("Warning", "" + code + " - " + description));
    }

    protected void maybeEnableCORS() {
        if (shouldEnableCORS) {
            this.enableCORS("*");
        }
    }

    private void enableCORS(String domain) {
        Series headers = (Series)this.getResponse().getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            this.getResponse().getAttributes().put("org.restlet.http.headers", headers);
        }
        headers.add((Object)new Header("Access-Control-Allow-Origin", domain));
    }
}

