/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet;

import java.io.File;
import java.io.StringReader;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.Request;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class MultipartRequestData {
    private static final Logger logger = LoggerFactory.getLogger((String)MultipartRequestData.class.getName());
    private final ZipFile zip;
    private final Document xml;

    private MultipartRequestData(ZipFile zip, Document xml) {
        this.zip = zip;
        this.xml = xml;
    }

    public ZipFile getZipFile() {
        return this.zip;
    }

    public Document getXml() {
        return this.xml;
    }

    public static MultipartRequestData processMultipart(Request request, String dataFieldName, String xmlFieldName, File tmpdir) throws Exception {
        logger.debug("tmpdir: " + tmpdir);
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(1000240);
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)fileItemFactory);
        ZipFile zip = null;
        String xml = "";
        List items = upload.parseRequest(request);
        for (FileItem fi : items) {
            if (fi.getFieldName().equals(dataFieldName)) {
                logger.debug("Reading zip file");
                File file = File.createTempFile("p2ws", ".zip", tmpdir);
                fi.write(file);
                File file2 = new File(file.getAbsolutePath());
                zip = new ZipFile(file2);
                continue;
            }
            if (!fi.getFieldName().equals(xmlFieldName)) continue;
            xml = fi.getString("utf-8");
            logger.debug("XML multi:" + xml);
        }
        if (zip == null || xml.length() == 0) {
            return null;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        Document doc = builder.parse(is);
        MultipartRequestData data = new MultipartRequestData(zip, doc);
        return data;
    }
}

