/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.webservice.restlet.AdminResource;
import org.daisy.pipeline.webservice.xml.ClientXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClientResource
extends AdminResource {
    private Optional<Client> client;
    private static Logger logger = LoggerFactory.getLogger((String)ClientResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthorized()) {
            return;
        }
        String idParam = (String)this.getRequestAttributes().get("id");
        this.client = this.getStorage().getClientStorage().get(idParam);
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.client.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Client not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        ClientXmlWriter writer = new ClientXmlWriter((Client)this.client.get(), this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }

    @Delete
    public void deleteResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return;
        }
        if (!this.client.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return;
        }
        if (this.getStorage().getClientStorage().delete(((Client)this.client.get()).getId())) {
            this.setStatus(Status.SUCCESS_NO_CONTENT);
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    @Put
    public Representation putResource(Representation representation) {
        this.logRequest();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.client.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Client not found, put method won't create a new client, it will just update an exisiting one");
        }
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("PUT request with no data");
        }
        Document doc = null;
        try {
            String s = representation.getText();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(s));
            doc = builder.parse(is);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        boolean isValid = XmlValidator.validate(doc, XmlValidator.CLIENT_SCHEMA_URL);
        if (!isValid) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Response xml not valid");
        }
        Element root = doc.getDocumentElement();
        Optional updated = this.getStorage().getClientStorage().update(((Client)this.client.get()).getId(), root.getAttribute("secret"), Client.Role.valueOf((String)root.getAttribute("role")), root.getAttribute("contact"), Priority.MEDIUM);
        if (!updated.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Something prevented this client to be updated");
        }
        this.setStatus(Status.SUCCESS_OK);
        ClientXmlWriter writer = new ClientXmlWriter((Client)updated.get(), this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }
}

