/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.webservice.restlet.AdminResource;
import org.daisy.pipeline.webservice.xml.ClientXmlWriter;
import org.daisy.pipeline.webservice.xml.ClientsXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClientsResource
extends AdminResource {
    private static Logger logger = LoggerFactory.getLogger((String)ClientsResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        this.setStatus(Status.SUCCESS_OK);
        ClientsXmlWriter writer = new ClientsXmlWriter(this.getStorage().getClientStorage().getAll(), this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }

    @Post
    public Representation createResource(Representation representation) {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Post request with no entity");
        }
        Document doc = null;
        try {
            String s = representation.getText();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(s));
            doc = builder.parse(is);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getErrorRepresentation(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getErrorRepresentation(e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getErrorRepresentation(e);
        }
        boolean isValid = XmlValidator.validate(doc, XmlValidator.CLIENT_SCHEMA_URL);
        if (!isValid) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Response XML not valid");
        }
        Element root = doc.getDocumentElement();
        Optional newClient = this.getStorage().getClientStorage().addClient(root.getAttribute("id"), root.getAttribute("secret"), Client.Role.valueOf((String)root.getAttribute("role")), root.getAttribute("contact"));
        if (!newClient.isPresent()) {
            logger.debug("Client id not unique");
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Client id not unique");
        }
        this.setStatus(Status.SUCCESS_CREATED);
        ClientXmlWriter writer = new ClientXmlWriter((Client)newClient.get(), this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }
}

