/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import org.daisy.pipeline.datatypes.DatatypeService;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeResource
extends AuthenticatedResource {
    private static final Logger logger = LoggerFactory.getLogger(DatatypeResource.class);
    private Optional<DatatypeService> datatype;
    private String idParam;

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        this.idParam = (String)this.getRequestAttributes().get("id");
        this.datatype = this.getDatatypeRegistry().getDatatype(this.idParam);
    }

    @Get(value="xml")
    public Representation getResource() {
        DomRepresentation dom;
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.datatype.isPresent()) {
            logger.info("Datatype not found: " + this.idParam);
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Datatype not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        try {
            dom = new DomRepresentation(MediaType.APPLICATION_XML, ((DatatypeService)this.datatype.get()).asDocument());
        }
        catch (Exception e) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation(e.getMessage());
        }
        this.logResponse(dom);
        return dom;
    }
}

