/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.restlet.impl.DatatypeResource;
import org.daisy.pipeline.webservice.xml.DatatypesXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypesResource
extends AuthenticatedResource {
    private static final Logger logger = LoggerFactory.getLogger(DatatypeResource.class);

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        DomRepresentation dom;
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        this.setStatus(Status.SUCCESS_OK);
        Iterable datatypes = this.getDatatypeRegistry().getDatatypes();
        try {
            dom = new DomRepresentation(MediaType.APPLICATION_XML, new DatatypesXmlWriter(datatypes, this.getRequest().getRootRef().toString()).getXmlDocument());
        }
        catch (Exception e) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation(e.getMessage());
        }
        this.logResponse(dom);
        return dom;
    }
}

