/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobBatchId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.webservice.restlet.impl.JobsResource;
import org.daisy.pipeline.webservice.xml.JobsXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.w3c.dom.Document;

public class JobBatchResource
extends JobsResource {
    JobBatchId batchId;

    @Override
    public void doInit() {
        super.doInit();
        String idParam = (String)this.getRequestAttributes().get("id");
        this.batchId = JobIdFactory.newBatchIdFromString((String)idParam);
    }

    @Override
    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        JobManager jobMan = this.getJobManager(this.getClient(), this.batchId);
        JobsXmlWriter writer = new JobsXmlWriter(jobMan.getJobs(), this.getJobManager(this.getStorage().getClientStorage().defaultClient()).getExecutionQueue(), this.getRequest().getRootRef().toString());
        if (this.getConfiguration().isLocalFS()) {
            writer.withLocalPaths();
        }
        Document doc = writer.getXmlDocument();
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, doc);
        this.setStatus(Status.SUCCESS_OK);
        this.logResponse(dom);
        return dom;
    }

    @Delete
    public void deleteResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return;
        }
        if (this.batchId == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient(), this.batchId);
        for (Job j : jobMan.deleteAll()) {
            this.getStorage().getJobConfigurationStorage().delete(j.getId());
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

