/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JobConfigurationResource
extends AuthenticatedResource {
    private Optional<Job> job = Optional.absent();
    private static Logger logger = LoggerFactory.getLogger((String)JobConfigurationResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        String idParam = (String)this.getRequestAttributes().get("id");
        try {
            JobId id = JobIdFactory.newIdFromString((String)idParam);
            this.job = jobMan.getJob(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Get
    public Representation getResource() {
        Document doc;
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        String xml = this.getStorage().getJobConfigurationStorage().get(((Job)this.job.get()).getId());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            doc = builder.parse(is);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, doc);
        this.setStatus(Status.SUCCESS_OK);
        this.logResponse(dom);
        return dom;
    }
}

