/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.xml.JobXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JobResource
extends AuthenticatedResource {
    private Optional<Job> job;
    private int msgSeq = -1;
    private static Logger logger = LoggerFactory.getLogger((String)JobResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        String idParam = (String)this.getRequestAttributes().get("id");
        String msgSeqParam = this.getQuery().getFirstValue("msgSeq");
        if (msgSeqParam != null) {
            this.msgSeq = Integer.parseInt(msgSeqParam);
        }
        try {
            JobId id = JobIdFactory.newIdFromString((String)idParam);
            this.job = jobMan.getJob(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.job = Optional.absent();
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        JobXmlWriter writer = new JobXmlWriter((Job)this.job.get(), this.getRequest().getRootRef().toString());
        writer.withFullResults(true);
        if (this.getConfiguration().isLocalFS()) {
            writer.withLocalPaths();
        }
        writer = this.msgSeq == -1 ? writer.withAllMessages() : writer.withNewMessages(this.msgSeq);
        if (((Job)this.job.get()).getStatus() == Job.Status.IDLE) {
            writer.withPriority(this.getJobPriority((Job)this.job.get()));
            int pos = this.getPositionInQueue((Job)this.job.get());
            writer.withQueuePosition(pos);
        }
        Document doc = writer.withScriptDetails().getXmlDocument();
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, doc);
        this.logResponse(dom);
        return dom;
    }

    private int getPositionInQueue(Job job) {
        int pos = this.getJobManager(this.getStorage().getClientStorage().defaultClient()).getExecutionQueue().getPositionInQueue(job.getId());
        if (pos < 0) {
            return pos;
        }
        return pos + 1;
    }

    private Priority getJobPriority(Job job) {
        return this.getJobManager(this.getStorage().getClientStorage().defaultClient()).getExecutionQueue().getJobPriority(job.getId());
    }

    @Delete
    public void deleteResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return;
        }
        if (this.job == null || !this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else {
            JobManager jobMan = this.getJobManager(this.getClient());
            if (jobMan.deleteJob(((Job)this.job.get()).getId()).isPresent()) {
                this.getStorage().getJobConfigurationStorage().delete(((Job)this.job.get()).getId());
                this.setStatus(Status.SUCCESS_NO_CONTENT);
            } else {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
    }
}

