/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobResources;
import org.daisy.pipeline.job.ZippedJobResources;
import org.daisy.pipeline.script.BoundScript;
import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptOption;
import org.daisy.pipeline.script.ScriptPort;
import org.daisy.pipeline.script.ScriptService;
import org.daisy.pipeline.webservice.Callback;
import org.daisy.pipeline.webservice.CallbackHandler;
import org.daisy.pipeline.webservice.impl.PosterCallback;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.restlet.MultipartRequestData;
import org.daisy.pipeline.webservice.xml.JobXmlWriter;
import org.daisy.pipeline.webservice.xml.JobsXmlWriter;
import org.daisy.pipeline.webservice.xml.ValidationStatus;
import org.daisy.pipeline.webservice.xml.Validator;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JobsResource
extends AuthenticatedResource {
    private static final String JOB_DATA_FIELD = "job-data";
    private static final String JOB_REQUEST_FIELD = "job-request";
    private static Logger logger = LoggerFactory.getLogger((String)JobsResource.class.getName());

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        JobsXmlWriter writer = new JobsXmlWriter(jobMan.getJobs(), this.getJobManager(this.getStorage().getClientStorage().defaultClient()).getExecutionQueue(), this.getRequest().getRootRef().toString());
        if (this.getConfiguration().isLocalFS()) {
            writer.withLocalPaths();
        }
        Document doc = writer.getXmlDocument();
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, doc);
        this.setStatus(Status.SUCCESS_OK);
        this.logResponse(dom);
        return dom;
    }

    @Post
    public Representation createResource(Representation representation) {
        Optional<Job> job;
        ValidationStatus status;
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("POST request with no entity");
        }
        Document doc = null;
        ZipFile zipfile = null;
        if (MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            Request request = this.getRequest();
            MultipartRequestData data = null;
            try {
                data = MultipartRequestData.processMultipart(request, JOB_DATA_FIELD, JOB_REQUEST_FIELD, new File(this.getConfiguration().getTmpDir()));
            }
            catch (Exception e) {
                return this.badRequest(e);
            }
            if (data == null) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return this.getErrorRepresentation("Multipart data is empty");
            }
            doc = data.getXml();
            zipfile = data.getZipFile();
        } else {
            try {
                String s = representation.getText();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(s));
                doc = builder.parse(is);
            }
            catch (IOException e) {
                return this.badRequest(e);
            }
            catch (ParserConfigurationException e) {
                return this.badRequest(e);
            }
            catch (SAXException e) {
                return this.badRequest(e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(XmlUtils.nodeToString(doc));
        }
        if (!(status = Validator.validateJobRequest(doc, this.getScriptRegistry())).isValid()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(status.getMessage());
        }
        try {
            job = this.createJob(doc, zipfile);
        }
        catch (LocalInputException e) {
            return this.badRequest(e);
        }
        catch (FileNotFoundException e) {
            return this.badRequest(e);
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e);
        }
        if (!job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Could not create job ");
        }
        this.getStorage().getJobConfigurationStorage().add(((Job)job.get()).getId(), XmlUtils.nodeToString(doc));
        JobXmlWriter writer = new JobXmlWriter((Job)job.get(), this.getRequest().getRootRef().toString());
        if (((Job)job.get()).getStatus() == Job.Status.IDLE) {
            writer.withPriority(this.getJobPriority((Job)job.get()));
        }
        Document jobXml = writer.withScriptDetails().getXmlDocument();
        this.registerCallbacks((Job)job.get(), doc);
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, jobXml);
        this.setStatus(Status.SUCCESS_CREATED);
        this.logResponse(dom);
        return dom;
    }

    private Priority getJobPriority(Job job) {
        return this.getJobManager(this.getStorage().getClientStorage().defaultClient()).getExecutionQueue().getJobPriority(job.getId());
    }

    private Representation badRequest(Exception e) {
        logger.error("bad request:", (Throwable)e);
        this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        return this.getErrorRepresentation(e.getMessage());
    }

    private Optional<Job> createJob(Document doc, ZipFile zip) throws LocalInputException, FileNotFoundException {
        Element scriptElm = (Element)doc.getElementsByTagNameNS(Validator.NS_DAISY, "script").item(0);
        Priority priority = Priority.MEDIUM;
        String niceName = "";
        NodeList elems = doc.getElementsByTagNameNS(Validator.NS_DAISY, "nicename");
        if (elems.getLength() != 0) {
            niceName = elems.item(0).getTextContent();
        }
        logger.debug(String.format("Job's nice name: %s", niceName));
        String batchId = "";
        elems = doc.getElementsByTagName("batchId");
        if (elems.getLength() != 0) {
            batchId = elems.item(0).getTextContent();
        }
        logger.debug(String.format("Job's batch id: %s", batchId));
        elems = doc.getElementsByTagNameNS(Validator.NS_DAISY, "priority");
        if (elems.getLength() != 0) {
            String prioString = elems.item(0).getTextContent();
            priority = Priority.valueOf((String)prioString.toUpperCase());
        }
        logger.debug(String.format("Jobs priority: %s", priority));
        String scriptId = scriptElm.getAttribute("href");
        if (scriptId.endsWith("/")) {
            scriptId = scriptId.substring(0, scriptId.length() - 1);
        }
        int idx = scriptId.lastIndexOf(47);
        scriptId = scriptId.substring(idx + 1);
        ScriptService scriptService = this.getScriptRegistry().getScript(scriptId);
        if (scriptService == null) {
            logger.error("Script not found");
            return Optional.absent();
        }
        Script script = scriptService.load();
        ZippedJobResources resourceCollection = zip != null ? new ZippedJobResources(zip) : null;
        BoundScript.Builder bound = new BoundScript.Builder(script, (JobResources)resourceCollection);
        this.addInputsToJob(doc.getElementsByTagNameNS(Validator.NS_DAISY, "input"), script, bound, zip != null);
        this.addOptionsToJob(doc.getElementsByTagNameNS(Validator.NS_DAISY, "option"), script, bound, zip != null);
        if (doc.getElementsByTagNameNS(Validator.NS_DAISY, "output").getLength() > 0) {
            logger.warn("Deprecated <output/> element used. Job results should be retrieved through the /jobs/ID/result API.");
            this.addWarningHeader(199, "\"Deprecated API\": <output/> is deprecated, job results should be retrieved through the /jobs/ID/result API");
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        return jobMan.newJob(bound.build()).withNiceName(niceName).withBatchId(JobIdFactory.newBatchIdFromString((String)batchId)).withPriority(priority).build();
    }

    private void registerCallbacks(Job job, Document doc) {
        NodeList callbacks = doc.getElementsByTagNameNS(Validator.NS_DAISY, "callback");
        for (int i = 0; i < callbacks.getLength(); ++i) {
            Element elm = (Element)callbacks.item(i);
            Callback.CallbackType type = Callback.CallbackType.valueOf(elm.getAttribute("type").toUpperCase());
            String frequency = elm.getAttribute("frequency");
            int freq = 0;
            if (frequency.length() > 0) {
                freq = Integer.parseInt(frequency);
            }
            try {
                URI href = new URI(elm.getAttribute("href"));
                CallbackHandler handler = this.getCallbackHandler();
                if (handler == null) {
                    throw new RuntimeException("No push notifier");
                }
                handler.addCallback(new PosterCallback(job, type, freq, href, this.getClient(), this.getRequest().getRootRef().toString()));
                continue;
            }
            catch (URISyntaxException e) {
                logger.warn("Cannot create callback: " + e.getMessage());
            }
        }
    }

    private void addInputsToJob(NodeList nodes, Script script, BoundScript.Builder builder, boolean zippedContext) throws LocalInputException, FileNotFoundException {
        for (ScriptPort input : script.getInputPorts()) {
            String inputName = input.getName();
            for (int i = 0; i < nodes.getLength(); ++i) {
                int j;
                Element inputElm = (Element)nodes.item(i);
                String name = inputElm.getAttribute("name");
                if (!name.equals(inputName)) continue;
                NodeList fileNodes = inputElm.getElementsByTagNameNS(Validator.NS_DAISY, "item");
                NodeList docwrapperNodes = inputElm.getElementsByTagNameNS(Validator.NS_DAISY, "docwrapper");
                if (fileNodes.getLength() > 0) {
                    for (j = 0; j < fileNodes.getLength(); ++j) {
                        URI src = URI.create(((Element)fileNodes.item(j)).getAttribute("value"));
                        this.checkInput(src, zippedContext);
                        builder.withInput(name, src);
                    }
                    continue;
                }
                for (j = 0; j < docwrapperNodes.getLength(); ++j) {
                    Element docwrapper = (Element)docwrapperNodes.item(j);
                    Node content = null;
                    for (int q = 0; q < docwrapper.getChildNodes().getLength(); ++q) {
                        if (docwrapper.getChildNodes().item(q).getNodeType() != 1) continue;
                        content = docwrapper.getChildNodes().item(q);
                        break;
                    }
                    SAXSource source = new SAXSource();
                    String xml = XmlUtils.nodeToString(content);
                    InputSource is = new InputSource(new StringReader(xml));
                    source.setInputSource(is);
                    builder.withInput(name, (Source)source);
                }
            }
        }
    }

    private void addOptionsToJob(NodeList nodes, Script script, BoundScript.Builder builder, boolean zippedContext) throws LocalInputException, FileNotFoundException {
        Iterable options = script.getOptions();
        block0: for (ScriptOption option : options) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element optionElm = (Element)nodes.item(i);
                String name = optionElm.getAttribute("name");
                if (!name.equals(option.getName())) continue;
                boolean isInput = "anyDirURI".equals(option.getType().getId()) || "anyFileURI".equals(option.getType().getId());
                NodeList items = optionElm.getElementsByTagNameNS(Validator.NS_DAISY, "item");
                if (items.getLength() > 0) {
                    for (int j = 0; j < items.getLength(); ++j) {
                        Element e = (Element)items.item(j);
                        String v = e.getAttribute("value");
                        if (isInput) {
                            this.checkInput(URI.create(v), zippedContext);
                        }
                        builder.withOption(option.getName(), v);
                    }
                    continue block0;
                }
                String v = optionElm.getTextContent();
                if (isInput) {
                    this.checkInput(URI.create(v), zippedContext);
                }
                builder.withOption(option.getName(), v);
                continue block0;
            }
        }
    }

    private void checkInput(URI uri, boolean zipFileSupplied) throws LocalInputException {
        if ("file".equals(uri.getScheme())) {
            if (!this.getConfiguration().isLocalFS()) {
                throw new LocalInputException("WS does not allow local inputs but a href starting with 'file:' was found " + uri);
            }
            if (zipFileSupplied) {
                throw new LocalInputException("You can't supply the data uri " + uri);
            }
        }
    }

    private class LocalInputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LocalInputException(String message) {
            super(message);
        }
    }
}

