/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.File;
import java.net.URI;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogResource
extends AuthenticatedResource {
    private Optional<Job> job = Optional.absent();
    private static Logger logger = LoggerFactory.getLogger((String)LogResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        String idParam = (String)this.getRequestAttributes().get("id");
        try {
            JobId id = JobIdFactory.newIdFromString((String)idParam);
            this.job = jobMan.getJob(id);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    @Get
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        URI logfileUri = ((Job)this.job.get()).getLogFile();
        if (logfileUri != null) {
            FileRepresentation logfile = new FileRepresentation(new File(logfileUri), MediaType.TEXT_PLAIN);
            return logfile;
        }
        return this.getErrorRepresentation("Log file was not present");
    }
}

