/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.Collection;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobResult;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.restlet.impl.ResultResource;
import org.restlet.data.Digest;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedResultResource
extends AuthenticatedResource {
    private Optional<Job> job = Optional.absent();
    private String idx;
    private String name;
    private static Logger logger = LoggerFactory.getLogger((String)NamedResultResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        String idParam = (String)this.getRequestAttributes().get("id");
        try {
            JobId id = JobIdFactory.newIdFromString((String)idParam);
            this.job = jobMan.getJob(id);
        }
        catch (Exception e) {
            logger.warn("Job Id malformed - Job not found: " + idParam);
        }
        if (this.getRequestAttributes().get("name") != null) {
            this.name = NamedResultResource.decode((String)this.getRequestAttributes().get("name"));
        }
        if (this.getRequestAttributes().get("idx") != null) {
            this.idx = NamedResultResource.decode((String)this.getRequestAttributes().get("idx"));
        }
    }

    @Get
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        if (!((Job)this.job.get()).getStatus().equals((Object)Job.Status.SUCCESS) && !((Job)this.job.get()).getStatus().equals((Object)Job.Status.FAIL)) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job status different to SUCCESS or FAIL");
        }
        if (this.name == null || this.name.isEmpty()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("No name provided");
        }
        if (this.idx != null && !this.idx.isEmpty()) {
            return this.singleResult();
        }
        return this.zippedResult();
    }

    private Representation singleResult() {
        Collection results = this.gatherResults((Job)this.job.get(), this.name);
        logger.debug(String.format("Getting single result for %s idx: %s", this.name, this.idx));
        results = Collections2.filter(results, (Predicate)new Predicate<JobResult>(){

            public boolean apply(JobResult res) {
                return res.getIdx().toString().equals(NamedResultResource.this.idx);
            }
        });
        if (results.size() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Result not found");
        }
        try {
            JobResult res = (JobResult)Lists.newArrayList((Iterable)results).get(0);
            InputStream is = res.asStream();
            is = new BufferedInputStream(is, 8192);
            Integer size = ResultResource.getSize(is, 32768);
            InputRepresentation rep = new InputRepresentation(is, MediaType.APPLICATION_ALL);
            if (size != null) {
                byte[] bytes = new byte[size.intValue()];
                is.mark(size);
                is.read(bytes);
                rep.setDigest(new Digest(MessageDigest.getInstance("MD5").digest(bytes)));
                is.reset();
            }
            Disposition disposition = new Disposition();
            disposition.setFilename(res.getIdx().toString());
            disposition.setType("attachment");
            if (size != null) {
                disposition.setSize((long)size.intValue());
            }
            rep.setDisposition(disposition);
            return rep;
        }
        catch (Exception e) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation(e);
        }
    }

    private Representation zippedResult() {
        Collection results = this.gatherResults((Job)this.job.get(), this.name);
        results = Collections2.transform(results, (Function)new Function<JobResult, JobResult>(){

            public JobResult apply(JobResult result) {
                return result.strip();
            }
        });
        logger.debug(String.format("Getting result for %s", this.name));
        if (results.size() == 0) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation("No results available");
        }
        try {
            return ResultResource.getZippedRepresentation(results, (Job)this.job.get());
        }
        catch (Exception e) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation(e);
        }
    }

    protected abstract Collection<JobResult> gatherResults(Job var1, String var2);

    private static String decode(String urlPart) {
        try {
            return new URI(urlPart).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error decoding url", e);
        }
    }
}

