/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.daisy.common.priority.Priority;
import org.daisy.common.spi.CreateOnStart;
import org.daisy.common.spi.ServiceLoader;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.clients.WebserviceStorage;
import org.daisy.pipeline.datatypes.DatatypeRegistry;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobBatchId;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobManagerFactory;
import org.daisy.pipeline.script.ScriptRegistry;
import org.daisy.pipeline.webservice.CallbackHandler;
import org.daisy.pipeline.webservice.PipelineWebServiceConfiguration;
import org.daisy.pipeline.webservice.Routes;
import org.daisy.pipeline.webservice.impl.PushNotifier;
import org.daisy.pipeline.webservice.impl.VolatileWebserviceStorage;
import org.daisy.pipeline.webservice.restlet.WebServiceExtension;
import org.daisy.pipeline.webservice.restlet.impl.AliveResource;
import org.daisy.pipeline.webservice.restlet.impl.ClientResource;
import org.daisy.pipeline.webservice.restlet.impl.ClientsResource;
import org.daisy.pipeline.webservice.restlet.impl.DatatypeResource;
import org.daisy.pipeline.webservice.restlet.impl.DatatypesResource;
import org.daisy.pipeline.webservice.restlet.impl.HaltResource;
import org.daisy.pipeline.webservice.restlet.impl.JobBatchResource;
import org.daisy.pipeline.webservice.restlet.impl.JobConfigurationResource;
import org.daisy.pipeline.webservice.restlet.impl.JobResource;
import org.daisy.pipeline.webservice.restlet.impl.JobsResource;
import org.daisy.pipeline.webservice.restlet.impl.LogResource;
import org.daisy.pipeline.webservice.restlet.impl.OptionResultResource;
import org.daisy.pipeline.webservice.restlet.impl.PipelineStatusService;
import org.daisy.pipeline.webservice.restlet.impl.PortResultResource;
import org.daisy.pipeline.webservice.restlet.impl.PropertiesResource;
import org.daisy.pipeline.webservice.restlet.impl.PropertyResource;
import org.daisy.pipeline.webservice.restlet.impl.QueueDownResource;
import org.daisy.pipeline.webservice.restlet.impl.QueueResource;
import org.daisy.pipeline.webservice.restlet.impl.QueueUpResource;
import org.daisy.pipeline.webservice.restlet.impl.ResultResource;
import org.daisy.pipeline.webservice.restlet.impl.ScriptResource;
import org.daisy.pipeline.webservice.restlet.impl.ScriptsResource;
import org.daisy.pipeline.webservice.restlet.impl.SizesResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.launch.Framework;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.osgi.service.component.annotations.Component(name="org.daisy.pipeline.webservice", immediate=true)
public class PipelineWebService
extends Application {
    private static Logger logger = LoggerFactory.getLogger((String)PipelineWebService.class.getName());
    public static final String KEY_FILE_NAME = "dp2key.txt";
    PipelineWebServiceConfiguration conf = new PipelineWebServiceConfiguration();
    private JobManagerFactory jobManagerFactory;
    private ScriptRegistry scriptRegistry;
    private WebserviceStorage webserviceStorage = null;
    private PushNotifier pushNotifier = null;
    private long shutDownKey = 0L;
    private Component component;
    private DatatypeRegistry datatypeRegistry;
    private List<WebServiceExtension> extensions = null;

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/scripts", ScriptsResource.class);
        router.attach("/scripts/{id}", ScriptResource.class);
        router.attach("/jobs", JobsResource.class);
        router.attach("/jobs/{id}", JobResource.class);
        router.attach("/batch/{id}", JobBatchResource.class);
        router.attach("/jobs/{id}/configuration", JobConfigurationResource.class);
        router.attach("/jobs/{id}/log", LogResource.class);
        router.attach("/jobs/{id}/result", ResultResource.class);
        router.attach("/jobs/{id}/result/option/{name}", OptionResultResource.class);
        TemplateRoute route = router.attach("/jobs/{id}/result/option/{name}/idx/{idx}", OptionResultResource.class);
        Map routeVariables = route.getTemplate().getVariables();
        routeVariables.put("idx", new Variable(8));
        router.attach("/jobs/{id}/result/port/{name}", PortResultResource.class);
        route = router.attach("/jobs/{id}/result/port/{name}/idx/{idx}", PortResultResource.class);
        routeVariables = route.getTemplate().getVariables();
        routeVariables.put("idx", new Variable(8));
        router.attach("/alive", AliveResource.class);
        router.attach("/admin/clients", ClientsResource.class);
        router.attach("/admin/clients/{id}", ClientResource.class);
        router.attach("/admin/properties", PropertiesResource.class);
        router.attach("/admin/properties/{name}", PropertyResource.class);
        router.attach("/admin/halt/{key}", HaltResource.class);
        router.attach("/admin/sizes", SizesResource.class);
        router.attach("/queue", QueueResource.class);
        router.attach("/queue/up/{jobId}", QueueUpResource.class);
        router.attach("/queue/down/{jobId}", QueueDownResource.class);
        router.attach("/datatypes/{id}", DatatypeResource.class);
        router.attach("/datatypes", DatatypesResource.class);
        if (this.extensions != null) {
            for (WebServiceExtension extension : this.extensions) {
                extension.attachTo(router);
            }
        }
        return router;
    }

    @Activate
    public void init() {
        if (this.webserviceStorage == null) {
            this.webserviceStorage = new VolatileWebserviceStorage();
        }
        if (!this.checkAuthenticationSanity()) {
            try {
                this.halt();
            }
            catch (Exception e) {
                logger.error("Error shutting down:" + e.getMessage());
            }
            return;
        }
        this.cleanUp();
        Routes routes = new Routes();
        logger.info(String.format("Starting webservice on port %d", routes.getPort()));
        this.component = new Component();
        if (!this.conf.isSsl()) {
            this.component.getServers().add(Protocol.HTTP, routes.getHost(), routes.getPort());
            logger.debug("Using HTTP");
        } else {
            Server server = this.component.getServers().add(Protocol.HTTPS, routes.getHost(), routes.getPort());
            server.getContext().getParameters().add("keystorePath", this.conf.getSslKeystore());
            server.getContext().getParameters().add("keystorePassword", this.conf.getSslKeystorePassword());
            server.getContext().getParameters().add("keyPassword", this.conf.getSslKeyPassword());
            logger.debug("Using HTTPS");
        }
        this.component.getDefaultHost().attach(routes.getPath(), (Restlet)this);
        this.setStatusService(new PipelineStatusService());
        try {
            this.component.start();
            logger.debug("component started");
            this.generateStopKey();
        }
        catch (Exception e) {
            logger.error("Shutting down the framework because of:" + e.getMessage());
            try {
                this.halt();
            }
            catch (Exception innerException) {
                logger.error("Error shutting down:" + e.getMessage());
            }
        }
        this.pushNotifier = new PushNotifier(this.jobManagerFactory);
    }

    private void cleanUp() {
        if (this.conf.getCleanUpOnStartUp()) {
            JobManager manager = this.getJobManager(this.webserviceStorage.getClientStorage().defaultClient());
            Iterable toClean = Iterables.filter((Iterable)manager.getJobs(), (Predicate)new Predicate<Job>(){

                public boolean apply(Job j) {
                    return j.getStatus().equals((Object)Job.Status.RUNNING) || j.getStatus().equals((Object)Job.Status.IDLE);
                }
            });
            for (Job j : toClean) {
                logger.info("Cleaning unfinished job " + j);
                manager.deleteJob(j.getId());
            }
        }
    }

    private boolean checkAuthenticationSanity() {
        if (this.conf.isAuthenticationEnabled() && this.webserviceStorage.getClientStorage().getAll().size() == 0) {
            if (this.conf.getClientKey() == null || this.conf.getClientSecret() == null || this.conf.getClientKey().isEmpty() || this.conf.getClientSecret().isEmpty()) {
                logger.error("\n\n************************************************************\nWS mode authenticated but the client store is empty, exiting\nplease provide values for the following properties:\n-org.daisy.pipeline.ws.authentication.key    \n-org.daisy.pipeline.ws.authentication.secret \n************************************************************\n\n\n");
                return false;
            }
            logger.debug("Inserting new client: " + this.conf.getClientKey());
            this.webserviceStorage.getClientStorage().addClient(this.conf.getClientKey(), this.conf.getClientSecret(), Client.Role.ADMIN, "from configuration", Priority.HIGH);
        }
        return true;
    }

    private void generateStopKey() throws IOException {
        this.shutDownKey = new Random().nextLong();
        File fout = new File(System.getProperty("java.io.tmpdir") + File.separator + KEY_FILE_NAME);
        FileOutputStream fos = new FileOutputStream(fout);
        fos.write((this.shutDownKey + "").getBytes());
        fos.close();
        logger.info("Shutdown key stored to: " + System.getProperty("java.io.tmpdir") + File.separator + KEY_FILE_NAME);
    }

    public boolean shutDown(long key) {
        if (key == this.shutDownKey) {
            this.halt();
            return true;
        }
        return false;
    }

    private void halt() {
        if (OSGiHelper.inOSGiContext()) {
            OSGiHelper.stopFramework();
        } else {
            this.close();
            System.exit(0);
        }
    }

    @Deactivate
    public void close() {
        try {
            this.pushNotifier.close();
            if (this.component != null) {
                this.component.stop();
            }
            this.stop();
            logger.info("Webservice stopped.");
        }
        catch (Exception e) {
            logger.error("Error stopping the web service:" + e.getMessage());
        }
    }

    @Reference(name="web-service-extension", unbind="-", service=WebServiceExtension.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addWebServiceExtension(WebServiceExtension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<WebServiceExtension>();
        }
        this.extensions.add(extension);
    }

    public JobManager getJobManager(Client client) {
        return this.jobManagerFactory.createFor(client);
    }

    public JobManager getJobManager(Client client, JobBatchId batchId) {
        return this.jobManagerFactory.createFor(client, batchId);
    }

    @Reference(name="job-manager-factory", unbind="-", service=JobManagerFactory.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setJobManagerFactory(JobManagerFactory jobManagerFactory) {
        this.jobManagerFactory = jobManagerFactory;
    }

    public PipelineWebServiceConfiguration getConfiguration() {
        return this.conf;
    }

    public ScriptRegistry getScriptRegistry() {
        return this.scriptRegistry;
    }

    @Reference(name="script-registry", unbind="-", service=ScriptRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setScriptRegistry(ScriptRegistry scriptRegistry) {
        this.scriptRegistry = scriptRegistry;
    }

    public WebserviceStorage getStorage() {
        return this.webserviceStorage;
    }

    @Reference(name="webservice-storage", unbind="-", service=WebserviceStorage.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC)
    public void setWebserviceStorage(WebserviceStorage webserviceStorage) {
        this.webserviceStorage = webserviceStorage;
    }

    public CallbackHandler getCallbackHandler() {
        return this.pushNotifier;
    }

    @Reference(name="datatype-registry", unbind="-", service=DatatypeRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setDatatypeRegistry(DatatypeRegistry datatypeRegistry) {
        this.datatypeRegistry = datatypeRegistry;
    }

    public DatatypeRegistry getDatatypeRegistry() {
        return this.datatypeRegistry;
    }

    public static void main(String[] args) {
        PipelineWebService webservice;
        if (args.length > 0) {
            logger.error("No arguments expected (got '" + String.join((CharSequence)" ", args) + "')");
            System.exit(1);
        }
        if ((webservice = SPIHelper.createWebService()) == null) {
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                webservice.close();
            }
        });
        System.err.println("Press Ctrl-C to exit");
    }

    private static abstract class SPIHelper {
        private SPIHelper() {
        }

        static PipelineWebService createWebService() {
            PipelineWebService webservice = null;
            for (CreateOnStart o : ServiceLoader.load(CreateOnStart.class)) {
                if (webservice != null || !(o instanceof PipelineWebService)) continue;
                webservice = (PipelineWebService)o;
            }
            return webservice;
        }
    }

    private static abstract class OSGiHelper {
        private OSGiHelper() {
        }

        static boolean inOSGiContext() {
            try {
                return FrameworkUtil.getBundle(OSGiHelper.class) != null;
            }
            catch (NoClassDefFoundError e) {
                return false;
            }
        }

        static void stopFramework() {
            try {
                ((Framework)FrameworkUtil.getBundle(OSGiHelper.class).getBundleContext().getBundle(0L)).stop();
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

