/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import java.util.ArrayList;
import org.daisy.common.properties.Properties;
import org.daisy.pipeline.webservice.restlet.AdminResource;
import org.daisy.pipeline.webservice.xml.PropertiesXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResource
extends AdminResource {
    private static Logger logger = LoggerFactory.getLogger((String)PropertiesResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return;
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        ArrayList<Properties.SettableProperty> properties = new ArrayList<Properties.SettableProperty>(Properties.getSettableProperties());
        PropertiesXmlWriter writer = new PropertiesXmlWriter(properties, this.getRequest().getRootRef().toString(), false);
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.setStatus(Status.SUCCESS_OK);
        if (logger.isDebugEnabled()) {
            logger.debug(XmlUtils.nodeToString(new PropertiesXmlWriter(properties, this.getRequest().getRootRef().toString(), true).getXmlDocument()));
        }
        return dom;
    }
}

