/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.daisy.common.properties.Properties;
import org.daisy.pipeline.webservice.restlet.AdminResource;
import org.daisy.pipeline.webservice.xml.PropertyXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyResource
extends AdminResource {
    private static Logger logger = LoggerFactory.getLogger((String)PropertyResource.class.getName());
    private Optional<Properties.SettableProperty> property;

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return;
        }
        String name = (String)this.getRequestAttributes().get("name");
        for (Properties.SettableProperty p : Properties.getSettableProperties()) {
            if (!name.equals(p.getName())) continue;
            this.property = Optional.of(p);
            break;
        }
        if (this.property == null) {
            this.property = Optional.empty();
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.property.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Property not found");
        }
        PropertyXmlWriter writer = new PropertyXmlWriter(this.property.get(), this.getRequest().getRootRef().toString(), false);
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.setStatus(Status.SUCCESS_OK);
        if (logger.isDebugEnabled()) {
            logger.debug(XmlUtils.nodeToString(new PropertyXmlWriter(this.property.get(), this.getRequest().getRootRef().toString(), true).getXmlDocument()));
        }
        return dom;
    }

    @Put
    public Representation putResource(Representation representation) {
        this.logRequest();
        if (!this.isAuthorized()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.property.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Property not found");
        }
        if (representation == null) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("PUT request with no data");
        }
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(representation.getText())));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error(e.getMessage());
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation(e);
        }
        if (!XmlValidator.validate(doc, XmlValidator.PROPERTY_SCHEMA_URL)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Invalid property XML provided");
        }
        Attr val = doc.getDocumentElement().getAttributeNode("value");
        if (val == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.getErrorRepresentation("Invalid property XML provided: 'property' element missing 'value' attribute");
        }
        this.property.get().setValue(val.getValue());
        PropertyXmlWriter writer = new PropertyXmlWriter(this.property.get(), this.getRequest().getRootRef().toString(), false);
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.setStatus(Status.SUCCESS_OK);
        if (logger.isDebugEnabled()) {
            logger.debug(XmlUtils.nodeToString(new PropertyXmlWriter(this.property.get(), this.getRequest().getRootRef().toString(), true).getXmlDocument()));
        }
        return dom;
    }
}

