/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobQueue;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.xml.QueueXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public abstract class QueueMoveResource
extends AuthenticatedResource {
    JobQueue queue;
    Optional<Job> job;

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        String idParam = (String)this.getRequestAttributes().get("jobId");
        JobManager manager = this.getJobManager(this.getClient());
        this.job = manager.getJob(JobIdFactory.newIdFromString((String)idParam));
        this.queue = manager.getExecutionQueue();
    }

    public abstract void move(JobQueue var1, JobId var2);

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        this.move(this.queue, ((Job)this.job.get()).getId());
        QueueXmlWriter writer = new QueueXmlWriter(this.queue, this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }
}

