/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import com.google.common.base.Optional;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobId;
import org.daisy.pipeline.job.JobIdFactory;
import org.daisy.pipeline.job.JobManager;
import org.daisy.pipeline.job.JobResult;
import org.daisy.pipeline.job.JobResultSet;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.restlet.data.Digest;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultResource
extends AuthenticatedResource {
    private Optional<Job> job = Optional.absent();
    private static Logger logger = LoggerFactory.getLogger((String)ResultResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        JobManager jobMan = this.getJobManager(this.getClient());
        String idParam = (String)this.getRequestAttributes().get("id");
        try {
            JobId id = JobIdFactory.newIdFromString((String)idParam);
            this.job = jobMan.getJob(id);
        }
        catch (Exception e) {
            logger.debug("Job Id malformed - Job not found: " + idParam);
        }
    }

    @Get
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (!this.job.isPresent()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job not found");
        }
        if (!((Job)this.job.get()).getStatus().equals((Object)Job.Status.SUCCESS) && !((Job)this.job.get()).getStatus().equals((Object)Job.Status.FAIL)) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Job status different to SUCCESS");
        }
        Collection results = ((Job)this.job.get()).getResults().getResults();
        if (results.size() == 0) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation("No results available");
        }
        try {
            return ResultResource.getZippedRepresentation(results, (Job)this.job.get());
        }
        catch (Exception e) {
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return this.getErrorRepresentation(e);
        }
    }

    public static Representation getZippedRepresentation(Collection<JobResult> results, Job job) throws IOException, NoSuchAlgorithmException {
        InputStream zip = JobResultSet.asZip(results);
        zip = new BufferedInputStream(zip, 8192);
        Integer size = ResultResource.getSize(zip, 32768);
        InputRepresentation rep = new InputRepresentation(zip, MediaType.APPLICATION_ZIP);
        if (size != null) {
            byte[] bytes = new byte[size.intValue()];
            zip.mark(size);
            zip.read(bytes);
            rep.setDigest(new Digest(MessageDigest.getInstance("MD5").digest(bytes)));
            zip.reset();
        }
        Disposition disposition = new Disposition();
        disposition.setFilename(job.getId().toString() + ".zip");
        disposition.setType("attachment");
        if (size != null) {
            disposition.setSize((long)size.intValue());
        }
        rep.setDisposition(disposition);
        return rep;
    }

    static Integer getSize(InputStream stream, int limit) throws IOException {
        Integer size = 0;
        if (!stream.markSupported()) {
            throw new RuntimeException();
        }
        stream.mark(limit + 2048);
        byte[] buf = new byte[2048];
        while (size != null && (size = Integer.valueOf(size + stream.read(buf))) > 0) {
            if (size <= limit) continue;
            size = null;
        }
        stream.reset();
        return size;
    }
}

