/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptService;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.xml.ScriptXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptResource
extends AuthenticatedResource {
    private Script script = null;
    private static Logger logger = LoggerFactory.getLogger((String)ScriptResource.class.getName());

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        String scriptId = null;
        scriptId = (String)this.getRequestAttributes().get("id");
        logger.debug("Script with id :" + scriptId);
        ScriptService scriptService = this.getScriptRegistry().getScript(scriptId);
        if (scriptService != null) {
            this.script = scriptService.load();
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        if (this.script == null) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return this.getErrorRepresentation("Script not found");
        }
        this.setStatus(Status.SUCCESS_OK);
        ScriptXmlWriter writer = new ScriptXmlWriter(this.script, this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.withDetails().getXmlDocument());
        this.logResponse(dom);
        return dom;
    }
}

