/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.restlet.impl;

import java.util.ArrayList;
import java.util.List;
import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptRegistry;
import org.daisy.pipeline.script.ScriptService;
import org.daisy.pipeline.webservice.restlet.AuthenticatedResource;
import org.daisy.pipeline.webservice.xml.ScriptsXmlWriter;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public class ScriptsResource
extends AuthenticatedResource {
    List<Script> scripts = null;

    @Override
    public void doInit() {
        super.doInit();
        if (!this.isAuthenticated()) {
            return;
        }
        ScriptRegistry scriptRegistry = this.getScriptRegistry();
        this.scripts = new ArrayList<Script>();
        for (ScriptService script : scriptRegistry.getScripts()) {
            this.scripts.add(script.load());
        }
    }

    @Get(value="xml")
    public Representation getResource() {
        this.logRequest();
        this.maybeEnableCORS();
        if (!this.isAuthenticated()) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return null;
        }
        this.setStatus(Status.SUCCESS_OK);
        ScriptsXmlWriter writer = new ScriptsXmlWriter(this.scripts, this.getRequest().getRootRef().toString());
        DomRepresentation dom = new DomRepresentation(MediaType.APPLICATION_XML, writer.getXmlDocument());
        this.logResponse(dom);
        return dom;
    }
}

