/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientXmlWriter {
    private final String baseUrl;
    private Client client = null;
    private static Logger logger = LoggerFactory.getLogger(ClientXmlWriter.class);

    public ClientXmlWriter(Client client, String baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.client == null) {
            logger.warn("Could not generate XML for null client");
            return null;
        }
        return ClientXmlWriter.clientToXmlDocument(this.client, this.baseUrl);
    }

    public void addAsElementChild(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element clientElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "client");
        ClientXmlWriter.addElementData(this.client, this.baseUrl, clientElm);
        parent.appendChild(clientElm);
    }

    private static Document clientToXmlDocument(Client client, String baseUrl) {
        Document doc = XmlUtils.createDom("client");
        Element rootElm = doc.getDocumentElement();
        ClientXmlWriter.addElementData(client, baseUrl, rootElm);
        if (!XmlValidator.validate(doc, XmlValidator.CLIENT_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }

    private static void addElementData(Client client, String baseUrl, Element element) {
        String clientHref = baseUrl + "/admin/clients/{id}".replaceFirst("\\{id\\}", client.getId());
        element.setAttribute("id", client.getId());
        element.setAttribute("href", clientHref);
        element.setAttribute("secret", client.getSecret());
        element.setAttribute("role", client.getRole().toString());
        element.setAttribute("contact", client.getContactInfo());
        element.setAttribute("priority", client.getPriority().name().toLowerCase());
    }
}

