/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import java.util.List;
import org.daisy.pipeline.clients.Client;
import org.daisy.pipeline.webservice.xml.ClientXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientsXmlWriter {
    private final String baseUrl;
    private List<? extends Client> clients = null;
    private static Logger logger = LoggerFactory.getLogger((String)ClientsXmlWriter.class.getName());

    public ClientsXmlWriter(List<? extends Client> clients, String baseUrl) {
        this.clients = clients;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.clients == null) {
            logger.warn("Could not generate XML for null clients");
            return null;
        }
        return this.clientsToXmlDoc();
    }

    private Document clientsToXmlDoc() {
        Document doc = XmlUtils.createDom("clients");
        Element clientsElm = doc.getDocumentElement();
        clientsElm.setAttribute("href", this.baseUrl + "/admin/clients");
        for (Client client : this.clients) {
            ClientXmlWriter writer = new ClientXmlWriter(client, this.baseUrl);
            writer.addAsElementChild(clientsElm);
        }
        if (!XmlValidator.validate(doc, XmlValidator.CLIENTS_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }
}

