/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.pipeline.datatypes.DatatypeService;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatatypesXmlWriter {
    private final String baseUrl;
    private Iterable<DatatypeService> datatypes;
    private static final Logger logger = LoggerFactory.getLogger(DatatypesXmlWriter.class);

    public DatatypesXmlWriter(Iterable<DatatypeService> datatypes, String baseUrl) {
        this.datatypes = datatypes;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.datatypes == null) {
            logger.warn("Null datatypes, couldn't create xml");
            return null;
        }
        return this.buildXml();
    }

    private Document buildXml() {
        Document doc = XmlUtils.createDom("datatypes");
        Element datatypesElem = doc.getDocumentElement();
        datatypesElem.setAttribute("href", this.baseUrl + "/datatypes");
        for (DatatypeService ds : this.datatypes) {
            Element dsElem = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "datatype");
            dsElem.setAttribute("id", ds.getId());
            dsElem.setAttribute("href", String.format("%s%s/%s", this.baseUrl, "/datatypes", ds.getId()));
            datatypesElem.appendChild(dsElem);
        }
        if (!XmlValidator.validate(doc, XmlValidator.DATATYPES_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }
}

