/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import java.math.BigDecimal;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.daisy.common.messaging.Message;
import org.daisy.common.messaging.MessageAccessor;
import org.daisy.common.messaging.ProgressMessage;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobResult;
import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptPort;
import org.daisy.pipeline.webservice.xml.ScriptXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JobXmlWriter {
    private final String baseUrl;
    private Job job = null;
    private List<Message> messages = null;
    private long messagesNewerThan = -1L;
    private BigDecimal progress = null;
    private boolean scriptDetails = false;
    private boolean fullResult = false;
    private boolean localPaths = false;
    private boolean onlyPrimaries = false;
    private Job.Status statusOverWrite = null;
    private Priority priority = null;
    private int queuePosition = -1;
    private static Logger logger = LoggerFactory.getLogger((String)JobXmlWriter.class.getName());
    private final HashSet<Message.Level> MSG_LEVELS;

    public JobXmlWriter(Job job, String baseUrl) {
        this(job, Message.Level.TRACE, baseUrl);
    }

    public JobXmlWriter(Job job, Message.Level messagesThreshold, String baseUrl) {
        this.job = job;
        this.baseUrl = baseUrl;
        this.MSG_LEVELS = new HashSet();
        this.MSG_LEVELS.add(Message.Level.ERROR);
        this.MSG_LEVELS.add(Message.Level.WARNING);
        this.MSG_LEVELS.add(Message.Level.INFO);
        if (Message.Level.INFO.isMoreSevereThan(messagesThreshold)) {
            this.MSG_LEVELS.add(Message.Level.DEBUG);
        }
    }

    public Document getXmlDocument() {
        if (this.job == null) {
            logger.warn("Could not create XML for null job.");
            return null;
        }
        return this.jobToXmlDocument();
    }

    public void addAsElementChild(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element jobElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "job");
        this.addElementData(this.job, jobElm);
        parent.appendChild(jobElm);
    }

    public JobXmlWriter withScriptDetails() {
        this.scriptDetails = true;
        return this;
    }

    public JobXmlWriter withLocalPaths() {
        this.localPaths = true;
        return this;
    }

    public JobXmlWriter withAllMessages() {
        MessageAccessor accessor = this.job.getMonitor().getMessageAccessor();
        if (accessor != null) {
            this.progress = accessor.getProgress();
            this.messages = accessor.createFilter().filterLevels(this.MSG_LEVELS).getMessages();
        }
        return this;
    }

    public JobXmlWriter withNewMessages(int newerThan) {
        MessageAccessor accessor = this.job.getMonitor().getMessageAccessor();
        if (accessor != null) {
            this.withProgress(accessor.getProgress());
            this.withMessages(accessor.createFilter().filterLevels(this.MSG_LEVELS).greaterThan(newerThan).getMessages(), newerThan);
        }
        return this;
    }

    public JobXmlWriter withMessages(List<Message> messages, int newerThan) {
        this.messages = messages;
        this.messagesNewerThan = newerThan;
        return this;
    }

    public JobXmlWriter withProgress(BigDecimal progress) {
        this.progress = progress;
        return this;
    }

    public void withFullResults(boolean fullResult) {
        this.fullResult = fullResult;
    }

    public void withOnlyPrimaries(boolean primaries) {
        this.onlyPrimaries = primaries;
    }

    public void overwriteStatus(Job.Status status) {
        this.statusOverWrite = status;
    }

    private Document jobToXmlDocument() {
        Document doc = XmlUtils.createDom("job");
        Element jobElm = doc.getDocumentElement();
        this.addElementData(this.job, jobElm);
        if (!XmlValidator.validate(doc, XmlValidator.JOB_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }

    private void addElementData(Job job, Element element) {
        URI logfileUri;
        Document doc = element.getOwnerDocument();
        Job.Status status = this.statusOverWrite == null ? job.getStatus() : this.statusOverWrite;
        String jobHref = this.baseUrl + "/jobs/{id}".replaceFirst("\\{id\\}", job.getId().toString());
        element.setAttribute("id", job.getId().toString());
        element.setAttribute("href", jobHref);
        element.setAttribute("status", status.toString());
        if (this.priority != null) {
            element.setAttribute("priority", this.priority.toString().toLowerCase());
        }
        if (this.queuePosition != -1) {
            element.setAttribute("queue-position", String.format("%d", this.queuePosition));
        }
        if (!job.getNiceName().isEmpty()) {
            Element nicenameElem = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "nicename");
            nicenameElem.setTextContent(job.getNiceName());
            element.appendChild(nicenameElem);
        }
        if (!job.getBatchId().toString().isEmpty()) {
            Element batchId = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "batchId");
            batchId.setTextContent(job.getBatchId().toString());
            element.appendChild(batchId);
        }
        if (this.scriptDetails) {
            Script script = job.getScript();
            ScriptXmlWriter writer = new ScriptXmlWriter(script, this.baseUrl);
            writer.addAsElementChild(element);
        }
        if (this.progress != null && status == Job.Status.RUNNING || this.messages != null && this.messages.size() > 0) {
            Element messagesElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "messages");
            element.appendChild(messagesElm);
            if (this.progress != null) {
                if (status == Job.Status.SUCCESS || job.getStatus() == Job.Status.FAIL) {
                    this.progress = BigDecimal.ONE;
                }
                messagesElm.setAttribute("progress", Float.toString(this.progress.floatValue()));
            }
            if (this.messages != null && this.messages.size() > 0) {
                if (this.messagesNewerThan >= 0L) {
                    messagesElm.setAttribute("msgSeq", "" + this.messagesNewerThan);
                }
                for (Message message : this.messages) {
                    JobXmlWriter.addMessage(message, true, messagesElm);
                }
            }
        }
        if (((status = job.getStatus()) == Job.Status.SUCCESS || status == Job.Status.FAIL || status == Job.Status.ERROR) && (logfileUri = job.getLogFile()) != null) {
            Element logElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "log");
            String logHref = this.baseUrl + "/jobs/{id}/log".replaceFirst("\\{id\\}", job.getId().toString());
            logElm.setAttribute("href", logHref);
            element.appendChild(logElm);
        }
        if (this.fullResult && (status == Job.Status.SUCCESS || status == Job.Status.FAIL)) {
            this.addResults(element);
        }
    }

    public static void addMessage(Message message, boolean progress, Element parentElem) {
        Document doc = parentElem.getOwnerDocument();
        Element messageElem = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "message");
        messageElem.setAttribute("level", message.getLevel().toString());
        messageElem.setAttribute("sequence", Integer.toString(message.getSequence()));
        messageElem.setAttribute("content", message.getText());
        messageElem.setAttribute("timeStamp", Long.toString(message.getTimeStamp().getTime()));
        if (message instanceof ProgressMessage) {
            ProgressMessage jm = (ProgressMessage)message;
            if (progress) {
                BigDecimal portion = jm.getPortion();
                if (portion.compareTo(BigDecimal.ZERO) > 0) {
                    messageElem.setAttribute("portion", Float.toString(portion.floatValue()));
                    messageElem.setAttribute("progress", Float.toString(jm.getProgress().floatValue()));
                } else {
                    progress = false;
                }
            }
            for (Message m : jm) {
                JobXmlWriter.addMessage(m, progress, messageElem);
            }
        }
        parentElem.appendChild(messageElem);
    }

    private void addResults(Element jobElem) {
        if (this.job.getResults() == null || this.job.getResults().getResults().size() == 0) {
            return;
        }
        Document doc = jobElem.getOwnerDocument();
        Element resultsElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "results");
        String resultHref = this.baseUrl + "/jobs/{id}/result".replaceFirst("\\{id\\}", this.job.getId().toString());
        resultsElm.setAttribute("href", resultHref);
        resultsElm.setAttribute("mime-type", "application/zip");
        jobElem.appendChild(resultsElm);
        for (String portName : this.job.getResults().getPorts()) {
            ScriptPort port = this.job.getScript().getOutputPort(portName);
            if (this.onlyPrimaries && !port.isPrimary()) continue;
            Element portResultElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "result");
            portResultElm.setAttribute("href", String.format("%s/port/%s", resultHref, portName));
            portResultElm.setAttribute("mime-type", "application/zip");
            portResultElm.setAttribute("from", "port");
            portResultElm.setAttribute("name", portName);
            portResultElm.setAttribute("nicename", port.getNiceName());
            String desc = port.getDescription();
            if (desc != null && !"".equals(desc)) {
                portResultElm.setAttribute("desc", desc);
            }
            resultsElm.appendChild(portResultElm);
            for (JobResult result : this.job.getResults().getResults(portName)) {
                Element resultElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "result");
                resultElm.setAttribute("href", String.format("%s/port/%s/idx/%s", resultHref, portName, result.getIdx()));
                if (result.getMediaType() != null && !result.getMediaType().isEmpty()) {
                    resultElm.setAttribute("mime-type", result.getMediaType());
                }
                if (this.localPaths) {
                    resultElm.setAttribute("file", result.getPath().toURI().toString());
                }
                resultElm.setAttribute("size", String.format("%s", result.getSize()));
                portResultElm.appendChild(resultElm);
            }
        }
    }

    public void withPriority(Priority priority) {
        this.priority = priority;
    }

    public void withQueuePosition(int pos) {
        this.queuePosition = pos;
    }
}

