/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.pipeline.job.JobSize;
import org.daisy.pipeline.webservice.xml.JobSizeXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JobsSizeXmlWriter {
    private final String baseUrl;
    Iterable<JobSize> sizes;
    private static final Logger logger = LoggerFactory.getLogger(JobsSizeXmlWriter.class);

    public JobsSizeXmlWriter(Iterable<JobSize> sizes, String baseUrl) {
        this.sizes = sizes;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.sizes == null) {
            logger.warn("Could not create XML for null jobs");
            return null;
        }
        return JobsSizeXmlWriter.sizesToXml(this.sizes, this.baseUrl);
    }

    private static Document sizesToXml(Iterable<JobSize> sizes, String baseUrl) {
        Document doc = XmlUtils.createDom("jobSizes");
        Element sizesElm = doc.getDocumentElement();
        sizesElm.setAttribute("href", baseUrl + "/admin/sizes");
        sizesElm.setAttribute("total", String.valueOf(JobSize.getTotal(sizes)));
        for (JobSize size : sizes) {
            JobSizeXmlWriter writer = new JobSizeXmlWriter(size);
            writer.addAsElementChild(sizesElm);
        }
        if (!XmlValidator.validate(doc, XmlValidator.SIZES_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }
}

