/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobQueue;
import org.daisy.pipeline.webservice.xml.JobXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JobsXmlWriter {
    private final String baseUrl;
    private final Iterable<? extends Job> jobs;
    private final JobQueue queue;
    private static Logger logger = LoggerFactory.getLogger((String)JobsXmlWriter.class.getName());
    private boolean localPaths = false;

    public JobsXmlWriter(Iterable<? extends Job> jobs, JobQueue queue, String baseUrl) {
        this.jobs = jobs;
        this.queue = queue;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.jobs == null) {
            logger.warn("Could not create XML for null jobs");
            return null;
        }
        return this.jobsToXml(this.jobs);
    }

    private Document jobsToXml(Iterable<? extends Job> jobs) {
        Document doc = XmlUtils.createDom("jobs");
        Element jobsElm = doc.getDocumentElement();
        jobsElm.setAttribute("href", this.baseUrl + "/jobs");
        for (Job job : jobs) {
            JobXmlWriter writer = new JobXmlWriter(job, this.baseUrl);
            writer.withFullResults(true);
            writer.withOnlyPrimaries(true);
            if (this.localPaths) {
                writer.withLocalPaths();
            }
            if (job.getStatus() == Job.Status.IDLE) {
                writer.withPriority(this.queue.getJobPriority(job.getId()));
            }
            writer.addAsElementChild(jobsElm);
        }
        if (!XmlValidator.validate(doc, XmlValidator.JOBS_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }

    public void withLocalPaths() {
        this.localPaths = true;
    }
}

