/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import java.util.List;
import org.daisy.common.properties.Properties;
import org.daisy.pipeline.webservice.xml.PropertyXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertiesXmlWriter {
    private static Logger logger = LoggerFactory.getLogger((String)PropertiesXmlWriter.class.getName());
    private final String baseUrl;
    private final List<Properties.SettableProperty> properties;
    private final boolean scrub;

    public PropertiesXmlWriter(List<Properties.SettableProperty> properties, String baseUrl, boolean scrub) {
        this.properties = properties;
        this.baseUrl = baseUrl;
        this.scrub = scrub;
    }

    public Document getXmlDocument() {
        Document doc = this.getXmlDocument(this.scrub);
        if (!XmlValidator.validate(doc, XmlValidator.PROPERTIES_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(this.scrub ? doc : this.getXmlDocument(true)));
        }
        return doc;
    }

    private Document getXmlDocument(boolean scrub) {
        Document doc = XmlUtils.createDom("properties");
        Element propsElm = doc.getDocumentElement();
        propsElm.setAttribute("href", this.baseUrl + "/admin/properties");
        for (Properties.SettableProperty p : this.properties) {
            PropertyXmlWriter writer = new PropertyXmlWriter(p, this.baseUrl, scrub);
            writer.addAsElementChild(propsElm);
        }
        return doc;
    }
}

