/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.common.properties.Properties;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyXmlWriter {
    private static Logger logger = LoggerFactory.getLogger(PropertyXmlWriter.class);
    private final String baseUrl;
    private final Properties.SettableProperty property;
    private final boolean scrub;

    public PropertyXmlWriter(Properties.SettableProperty property, String baseUrl, boolean scrub) {
        this.property = property;
        this.baseUrl = baseUrl;
        this.scrub = scrub;
    }

    public Document getXmlDocument() {
        Document doc = this.getXmlDocument(this.scrub);
        if (!XmlValidator.validate(doc, XmlValidator.PROPERTY_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(this.scrub ? doc : this.getXmlDocument(true)));
        }
        return doc;
    }

    private Document getXmlDocument(boolean scrub) {
        Document doc = XmlUtils.createDom("property");
        this.addElementData(doc.getDocumentElement());
        return doc;
    }

    void addAsElementChild(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element propertyElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "property");
        this.addElementData(propertyElm);
        parent.appendChild(propertyElm);
    }

    private void addElementData(Element element) {
        String description;
        element.setAttribute("href", this.baseUrl + "/admin/properties/{name}".replaceFirst("\\{name\\}", this.property.getName()));
        element.setAttribute("name", this.property.getName());
        String val = this.property.getValue();
        if (val != null) {
            element.setAttribute("value", this.scrub && this.property.isSensitive() ? "***" : val);
        }
        if ((description = this.property.getDescription()) != null) {
            element.setAttribute("desc", description);
        }
    }
}

