/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.common.priority.Prioritizable;
import org.daisy.common.priority.Priority;
import org.daisy.pipeline.job.Job;
import org.daisy.pipeline.job.JobQueue;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QueueXmlWriter {
    private static final Logger logger = LoggerFactory.getLogger(QueueXmlWriter.class);
    private final String baseUrl;
    private final JobQueue queue;

    public QueueXmlWriter(JobQueue queue, String baseUrl) {
        this.queue = queue;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        Document doc = XmlUtils.createDom("queue");
        Element queueElem = doc.getDocumentElement();
        queueElem.setAttribute("href", this.baseUrl + "/queue");
        for (Prioritizable job : this.queue.asCollection()) {
            this.addElementData((Prioritizable<Job>)job, queueElem);
        }
        if (!XmlValidator.validate(doc, XmlValidator.QUEUE_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }

    private void addElementData(Prioritizable<Job> job, Element parent) {
        Priority clientPrio;
        Element element = parent.getOwnerDocument().createElementNS("http://www.daisy.org/ns/pipeline/data", "job");
        element.setAttribute("id", ((Job)job.prioritySource()).getId().toString());
        element.setAttribute("href", this.baseUrl + "/jobs/" + ((Job)job.prioritySource()).getId().toString());
        element.setAttribute("computedPriority", String.valueOf(job.getPriority()));
        Priority jobPrio = this.queue.getJobPriority(((Job)job.prioritySource()).getId());
        if (jobPrio != null) {
            element.setAttribute("jobPriority", String.valueOf(jobPrio).toLowerCase());
        }
        if ((clientPrio = this.queue.getClientPriority(((Job)job.prioritySource()).getId())) != null) {
            element.setAttribute("clientPriority", String.valueOf(clientPrio).toLowerCase());
        }
        element.setAttribute("relativeTime", String.valueOf(job.getRelativeWaitingTime()));
        element.setAttribute("timestamp", String.valueOf(job.getTimestamp()));
        element.setAttribute("moveUp", this.baseUrl + "/queue/up/" + ((Job)job.prioritySource()).getId().toString());
        element.setAttribute("moveDown", this.baseUrl + "/queue/down/" + ((Job)job.prioritySource()).getId().toString());
        parent.appendChild(element);
    }
}

