/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptOption;
import org.daisy.pipeline.script.ScriptPort;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScriptXmlWriter {
    private final String baseUrl;
    private Script script = null;
    private boolean details = false;
    private static Logger logger = LoggerFactory.getLogger((String)ScriptXmlWriter.class.getName());

    public ScriptXmlWriter(Script script, String baseUrl) {
        this.script = script;
        this.baseUrl = baseUrl;
    }

    public ScriptXmlWriter withDetails() {
        this.details = true;
        return this;
    }

    public Document getXmlDocument() {
        if (this.script == null) {
            logger.warn("Could not create XML for null script");
            return null;
        }
        return this.scriptToXmlDocument(this.script);
    }

    public void addAsElementChild(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element scriptElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "script");
        this.addElementData(this.script, scriptElm);
        parent.appendChild(scriptElm);
    }

    private Document scriptToXmlDocument(Script script) {
        Document doc = XmlUtils.createDom("script");
        Element scriptElm = doc.getDocumentElement();
        this.addElementData(script, scriptElm);
        if (!XmlValidator.validate(doc, XmlValidator.SCRIPT_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }

    private void addElementData(Script script, Element element) {
        Document doc = element.getOwnerDocument();
        String scriptHref = this.baseUrl + "/scripts/{id}".replaceFirst("\\{id\\}", script.getId());
        element.setAttribute("id", script.getId());
        element.setAttribute("href", scriptHref);
        Joiner joiner = Joiner.on((String)" ");
        if (!Iterables.isEmpty((Iterable)script.getInputFilesets())) {
            element.setAttribute("input-filesets", joiner.join(script.getInputFilesets()));
        }
        if (!Iterables.isEmpty((Iterable)script.getOutputFilesets())) {
            element.setAttribute("output-filesets", joiner.join(script.getOutputFilesets()));
        }
        Element nicenameElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "nicename");
        nicenameElm.setTextContent(script.getName());
        element.appendChild(nicenameElm);
        Element descriptionElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "description");
        descriptionElm.setTextContent(script.getDescription());
        element.appendChild(descriptionElm);
        Element versionElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "version");
        versionElm.setTextContent(script.getVersion());
        element.appendChild(versionElm);
        if (this.details) {
            String homepage = script.getHomepage();
            if (homepage != null && homepage.trim().length() > 0) {
                Element homepageElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "homepage");
                homepageElm.setTextContent(homepage);
                element.appendChild(homepageElm);
            }
            ScriptXmlWriter.addInputPorts(script.getInputPorts(), element);
            ScriptXmlWriter.addOptions(script.getOptions(), element);
        }
    }

    private static void addInputPorts(Iterable<ScriptPort> ports, Element parent) {
        Document doc = parent.getOwnerDocument();
        for (ScriptPort port : ports) {
            Element inputElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "input");
            inputElm.setAttribute("name", port.getName());
            inputElm.setAttribute("nicename", port.getNiceName());
            inputElm.setAttribute("required", Boolean.toString(port.isRequired()));
            inputElm.setAttribute("sequence", Boolean.toString(port.isSequence()));
            if (port.getMediaType() != null && !port.getMediaType().isEmpty()) {
                inputElm.setAttribute("mediaType", port.getMediaType());
            }
            inputElm.setAttribute("desc", port.getDescription());
            parent.appendChild(inputElm);
        }
    }

    private static void addOptions(Iterable<ScriptOption> options, Element parent) {
        Document doc = parent.getOwnerDocument();
        for (ScriptOption option : options) {
            Element optionElm = doc.createElementNS("http://www.daisy.org/ns/pipeline/data", "option");
            optionElm.setAttribute("name", option.getName().toString());
            optionElm.setAttribute("nicename", option.getNiceName());
            optionElm.setAttribute("required", Boolean.toString(option.isRequired()));
            optionElm.setAttribute("type", option.getType().getId());
            if (option.getMediaType() != null && !option.getMediaType().isEmpty()) {
                optionElm.setAttribute("mediaType", option.getMediaType());
            }
            optionElm.setAttribute("desc", option.getDescription());
            optionElm.setAttribute("ordered", Boolean.toString(option.isOrdered()));
            optionElm.setAttribute("sequence", Boolean.toString(option.isSequence()));
            if (!option.isRequired()) {
                optionElm.setAttribute("default", option.getDefault());
            }
            parent.appendChild(optionElm);
        }
    }
}

