/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.webservice.xml.ScriptXmlWriter;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScriptsXmlWriter {
    private final String baseUrl;
    Iterable<Script> scripts = null;
    private static Logger logger = LoggerFactory.getLogger((String)ScriptsXmlWriter.class.getName());

    public ScriptsXmlWriter(Iterable<Script> scripts, String baseUrl) {
        this.scripts = scripts;
        this.baseUrl = baseUrl;
    }

    public Document getXmlDocument() {
        if (this.scripts == null) {
            logger.warn("Could not create XML for null scripts");
            return null;
        }
        return this.scriptsToXml(this.scripts);
    }

    private Document scriptsToXml(Iterable<Script> scripts) {
        Document doc = XmlUtils.createDom("scripts");
        Element scriptsElm = doc.getDocumentElement();
        scriptsElm.setAttribute("href", this.baseUrl + "/scripts");
        for (Script script : scripts) {
            ScriptXmlWriter writer = new ScriptXmlWriter(script, this.baseUrl);
            writer.addAsElementChild(scriptsElm);
        }
        if (!XmlValidator.validate(doc, XmlValidator.SCRIPTS_SCHEMA_URL)) {
            logger.error("INVALID XML:\n" + XmlUtils.nodeToString(doc));
        }
        return doc;
    }
}

