/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.daisy.pipeline.script.Script;
import org.daisy.pipeline.script.ScriptRegistry;
import org.daisy.pipeline.script.ScriptService;
import org.daisy.pipeline.webservice.xml.ValidationStatus;
import org.daisy.pipeline.webservice.xml.XmlUtils;
import org.daisy.pipeline.webservice.xml.XmlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Validator {
    private static Logger logger = LoggerFactory.getLogger((String)Validator.class.getName());
    public static String NS_DAISY = "http://www.daisy.org/ns/pipeline/data";

    public static boolean validateXmlAgainstSchema(Document document, URL schema) {
        return XmlValidator.validate(document, schema);
    }

    public static ValidationStatus validateJobRequest(Document doc, ScriptRegistry scriptRegistry) {
        boolean xmlValid = Validator.validateXmlAgainstSchema(doc, XmlValidator.JOB_REQUEST_SCHEMA_URL);
        if (!xmlValid) {
            return new ValidationStatus(false, "The request is not valid");
        }
        return Validator.validateJobRequestArguments(doc, scriptRegistry);
    }

    private static ValidationStatus validateJobRequestArguments(Document doc, ScriptRegistry scriptRegistry) {
        int idx;
        ScriptService scriptService;
        Element scriptElm = (Element)doc.getElementsByTagNameNS(NS_DAISY, "script").item(0);
        String scriptId = scriptElm.getAttribute("href");
        if (scriptId.endsWith("/")) {
            scriptId = scriptId.substring(0, scriptId.length() - 1);
        }
        if ((scriptService = scriptRegistry.getScript(scriptId = scriptId.substring((idx = scriptId.lastIndexOf(47)) + 1))) == null) {
            String message = "Script not found";
            logger.error(message);
            return new ValidationStatus(false, message);
        }
        Script script = scriptService.load();
        ValidationStatus hasAllRequiredInputs = Validator.validateJobRequestInputPortData(doc.getElementsByTagNameNS(NS_DAISY, "input"), script);
        if (!hasAllRequiredInputs.isValid()) {
            return hasAllRequiredInputs;
        }
        ValidationStatus hasAllRequiredOptions = Validator.validateJobRequestOptionData(doc.getElementsByTagNameNS(NS_DAISY, "option"), script);
        return hasAllRequiredOptions;
    }

    private static ValidationStatus validateJobRequestOptionData(NodeList nodes, Script script) {
        boolean hasAllRequiredArgs = true;
        ArrayList<String> missingArgs = new ArrayList<String>();
        for (Object option : script.getOptions()) {
            if (!option.isRequired()) continue;
            boolean validArg = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elm = (Element)nodes.item(i);
                if (!elm.getAttribute("name").equals(option.getName().toString())) continue;
                if (!option.isSequence()) {
                    validArg = Validator.validateOptionType(elm.getTextContent(), option.getMediaType());
                    break;
                }
                validArg = true;
                break;
            }
            hasAllRequiredArgs &= validArg;
            if (validArg) continue;
            missingArgs.add(option.getName().toString());
        }
        if (!hasAllRequiredArgs) {
            String missingArgsStr = "";
            for (String s : missingArgs) {
                missingArgsStr = missingArgsStr + s + ",";
            }
            String message = "Required JobRequest option(s) missing: " + missingArgsStr;
            logger.error(message);
            return new ValidationStatus(false, message);
        }
        return new ValidationStatus(true);
    }

    private static ValidationStatus validateJobRequestInputPortData(NodeList nodes, Script script) {
        boolean hasAllRequiredArgs = true;
        ArrayList<String> missingArgs = new ArrayList<String>();
        for (Object port : script.getInputPorts()) {
            boolean validArg = !port.isRequired();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elm = (Element)nodes.item(i);
                if (!elm.getAttribute("name").equals(port.getName())) continue;
                NodeList itemNodes = elm.getElementsByTagNameNS(NS_DAISY, "item");
                NodeList docwrapperNodes = elm.getElementsByTagNameNS(NS_DAISY, "docwrapper");
                if (itemNodes.getLength() == 0 && docwrapperNodes.getLength() == 0) {
                    validArg = false;
                    break;
                }
                if (itemNodes.getLength() > 0) {
                    validArg = Validator.validateItemElements(itemNodes);
                    break;
                }
                validArg = Validator.validateDocwrapperElements(docwrapperNodes, port.getMediaType());
                break;
            }
            hasAllRequiredArgs &= validArg;
            if (validArg) continue;
            missingArgs.add(port.getName());
        }
        if (!hasAllRequiredArgs) {
            String missingArgsStr = "";
            for (String s : missingArgs) {
                missingArgsStr = missingArgsStr + s + ",";
            }
            String message = "Required jobRequest input port arg(s) missing: " + missingArgsStr;
            logger.error(message);
            return new ValidationStatus(false, message);
        }
        return new ValidationStatus(true);
    }

    private static boolean validateDocwrapperElements(NodeList nodes, String mediaType) {
        boolean isValid = true;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node docwrapper = nodes.item(i);
            Node content = null;
            for (int q = 0; q < docwrapper.getChildNodes().getLength(); ++q) {
                if (docwrapper.getChildNodes().item(q).getNodeType() != 1) continue;
                content = docwrapper.getChildNodes().item(q);
                break;
            }
            String xml = XmlUtils.nodeToString(content);
            isValid &= Validator.validateWellFormedXml(xml);
        }
        return isValid;
    }

    private static boolean validateItemElements(NodeList nodes) {
        boolean isValid = true;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elm = (Element)nodes.item(i);
            isValid &= elm.getAttribute("value").trim().length() > 0;
        }
        return isValid;
    }

    private static boolean validateOptionType(String value, String mediaType) {
        return value.trim().length() > 0;
    }

    private static boolean validateWellFormedXml(String xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            db.parse(is);
            ((InputStream)is).close();
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }
}

