/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.webservice.xml;

import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlValidator {
    private static Logger logger = LoggerFactory.getLogger((String)XmlValidator.class.getName());
    public static final URL SCRIPT_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/script/script.rnc");
    public static final URL SCRIPTS_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/script/scripts.rnc");
    public static final URL JOB_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/job/job.rnc");
    public static final URL JOB_REQUEST_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/request/jobRequest.rnc");
    public static final URL JOBS_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/job/jobs.rnc");
    public static final URL CLIENT_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/client/client.rnc");
    public static final URL CLIENTS_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/client/clients.rnc");
    public static final URL ERROR_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/base/error.rnc");
    public static final URL ALIVE_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/base/alive.rnc");
    public static final URL SIZES_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/job/sizes.rnc");
    public static final URL QUEUE_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/queue/queue.rnc");
    public static final URL DATATYPES_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/datatypes.rnc");
    public static final URL PROPERTY_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/properties/property.rnc");
    public static final URL PROPERTIES_SCHEMA_URL = XmlValidator.class.getResource("/org/daisy/pipeline/webservice/resources/properties/properties.rnc");

    public static boolean validate(Document document, URL schemaUrl) {
        if (schemaUrl == null) {
            logger.error("schema url is null");
            return false;
        }
        ErrorHandlerImpl errorHandler = new ErrorHandlerImpl();
        PropertyMapBuilder properties = new PropertyMapBuilder();
        properties.put(ValidateProperty.ERROR_HANDLER, (Object)errorHandler);
        properties.put(ValidateProperty.RESOLVER, (Object)BasicResolver.getInstance());
        try {
            InputSource documentInputSource = XmlValidator.DOMtoInputSource(document);
            InputSource schemaInputSource = new InputSource(schemaUrl.toURI().toString());
            ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), CompactSchemaReader.getInstance());
            if (!driver.loadSchema(schemaInputSource)) {
                logger.error("Could not load schema " + schemaUrl.toString());
                return false;
            }
            driver.validate(documentInputSource);
        }
        catch (TransformerConfigurationException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (TransformerException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (SAXException e) {
            logger.error(e.getMessage());
            return false;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return false;
        }
        if (errorHandler.hasErrors()) {
            for (SAXParseException e : errorHandler.errors) {
                logger.error(e.getMessage() + "(" + e.getLineNumber() + ", " + e.getColumnNumber() + ")");
            }
        }
        return !errorHandler.hasErrors();
    }

    private static InputSource DOMtoInputSource(Document doc) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        DOMSource source = new DOMSource(doc);
        StringWriter xmlAsWriter = new StringWriter();
        StreamResult result = new StreamResult(xmlAsWriter);
        TransformerFactory.newInstance().newTransformer().transform(source, result);
        StringReader xmlReader = new StringReader(xmlAsWriter.toString());
        InputSource is = new InputSource(xmlReader);
        return is;
    }

    public static class BasicResolver
    implements Resolver {
        private static final BasicResolver theInstance = new BasicResolver();

        protected BasicResolver() {
        }

        public static BasicResolver getInstance() {
            return theInstance;
        }

        public void resolve(Identifier id, Input input) throws IOException, ResolverException {
            if (!input.isResolved()) {
                input.setUri(BasicResolver.resolveUri(id));
            }
        }

        public void open(Input input) throws IOException, ResolverException {
            URI uri;
            if (!input.isUriDefinitive()) {
                return;
            }
            try {
                uri = new URI(input.getUri());
            }
            catch (URISyntaxException e) {
                throw new ResolverException((Throwable)e);
            }
            if (!uri.isAbsolute()) {
                throw new ResolverException("cannot open relative URI: " + uri);
            }
            URL url = new URL(uri.toASCIIString());
            input.setByteStream(url.openStream());
        }

        public static String resolveUri(Identifier id) throws ResolverException {
            try {
                String base;
                String uriRef = id.getUriReference();
                URI uri = new URI(uriRef);
                if (!uri.isAbsolute() && (base = id.getBase()) != null) {
                    URI baseURI = new URI(base);
                    uriRef = "zip".equals(baseURI.getScheme()) || "jar".equals(baseURI.getScheme()) ? new URL(new URL(base), uriRef).toExternalForm() : baseURI.resolve(uri).toString();
                }
                return uriRef;
            }
            catch (URISyntaxException e) {
                throw new ResolverException((Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ResolverException((Throwable)e);
            }
        }
    }

    public static class ErrorHandlerImpl
    implements ErrorHandler {
        List<SAXParseException> errors = new ArrayList<SAXParseException>();

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }
    }
}

