/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.SourceLocator;
import org.daisy.common.stax.XMLStreamWriterHelper;

public abstract class XProcError {
    private static final QName C_ERROR = new QName("http://www.w3.org/ns/xproc-step", "error");
    private static final QName PX_LOCATION = new QName("http://www.daisy.org/ns/pipeline/xproc", "location");
    private static final QName PX_FILE = new QName("http://www.daisy.org/ns/pipeline/xproc", "file");
    private static final QName PX_CAUSE = new QName("http://www.daisy.org/ns/pipeline/xproc", "cause");
    private static final QName _CODE = new QName("code");
    private static final QName _HREF = new QName("href");
    private static final QName _LINE = new QName("line");

    public abstract QName getCode();

    public abstract String getMessage();

    public abstract XProcError getCause();

    public abstract SourceLocator[] getLocation();

    private String printEnclosedLocation(SourceLocator[] enclosingLocation) {
        XProcError cause;
        StringBuilder s = new StringBuilder();
        if (this.getCode() != null) {
            s.append("[").append(this.getCode()).append("]");
            if (this.getMessage() != null) {
                s.append(" ").append(this.getMessage());
            }
        } else {
            s.append(this.getMessage());
        }
        SourceLocator[] loc = this.getLocation();
        int m = loc.length - 1;
        for (int n = enclosingLocation.length - 1; m >= 0 && n >= 0 && loc[m].equals(enclosingLocation[n]); --m, --n) {
        }
        int inCommon = loc.length - 1 - m;
        for (int i = 0; i <= m; ++i) {
            s.append("\n\tat " + loc[i]);
        }
        if (inCommon != 0) {
            s.append("\n\t... " + inCommon + " more");
        }
        if ((cause = this.getCause()) != null) {
            s.append("\nCaused by: ");
            s.append(cause.printEnclosedLocation(loc));
        }
        return s.toString();
    }

    public String toString() {
        return this.printEnclosedLocation(new SourceLocator[0]);
    }

    public static XProcError parse(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 7) {
            reader.next();
        }
        if (reader.getEventType() != 1) {
            throw new IllegalArgumentException();
        }
        if (!C_ERROR.equals(reader.getName())) {
            throw new IllegalArgumentException();
        }
        QName code = null;
        String message = null;
        ArrayList<PxFileLocation> location = null;
        XProcError cause = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            QName name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if (!_CODE.equals(name)) continue;
            if (value.contains(":")) {
                String prefix = value.substring(0, value.indexOf(":"));
                String namespace = reader.getNamespaceContext().getNamespaceURI(prefix);
                String localPart = value.substring(prefix.length() + 1, value.length());
                code = new QName(namespace, localPart, prefix);
                break;
            }
            code = new QName(value);
            break;
        }
        Stack<QName> parents = new Stack<QName>();
        int event = reader.next();
        try {
            while (true) {
                switch (event) {
                    case 1: {
                        if (C_ERROR.equals(reader.getName())) {
                            if (parents.size() == 1 && PX_CAUSE.equals(parents.peek())) {
                                cause = XProcError.parse(reader);
                                break;
                            }
                            XMLStreamWriterHelper.skipElement((XMLStreamReader)reader);
                            break;
                        }
                        if (PX_FILE.equals(reader.getName())) {
                            if (parents.size() == 1 && PX_LOCATION.equals(parents.peek())) {
                                if (location == null) {
                                    location = new ArrayList<PxFileLocation>();
                                }
                                location.add(new PxFileLocation(reader));
                                break;
                            }
                            XMLStreamWriterHelper.skipElement((XMLStreamReader)reader);
                            break;
                        }
                        parents.add(reader.getName());
                        break;
                    }
                    case 2: {
                        if (C_ERROR.equals(reader.getName())) {
                            final QName _code = code;
                            final String _message = message;
                            final SourceLocator[] _location = location == null ? new SourceLocator[]{} : location.toArray(new SourceLocator[location.size()]);
                            final XProcError _cause = cause;
                            return new XProcError(){

                                @Override
                                public QName getCode() {
                                    return _code;
                                }

                                @Override
                                public String getMessage() {
                                    return _message;
                                }

                                @Override
                                public XProcError getCause() {
                                    return _cause;
                                }

                                @Override
                                public SourceLocator[] getLocation() {
                                    return _location;
                                }
                            };
                        }
                        parents.pop();
                        break;
                    }
                    case 4: {
                        message = message == null ? reader.getText() : message + reader.getText();
                        break;
                    }
                }
                event = reader.next();
            }
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("coding error");
        }
    }

    private static class PxFileLocation
    implements SourceLocator {
        private String href = "";
        private int line = -1;

        PxFileLocation(XMLStreamReader reader) throws XMLStreamException {
            if (!PX_FILE.equals(reader.getName())) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                QName name = reader.getAttributeName(i);
                String value = reader.getAttributeValue(i);
                if (_HREF.equals(name)) {
                    this.href = value;
                    continue;
                }
                if (!_LINE.equals(name)) continue;
                try {
                    this.line = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            XMLStreamWriterHelper.skipElement((XMLStreamReader)reader);
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.href;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            String fileName = this.getSystemId();
            if (fileName != null && !"".equals(fileName)) {
                if (fileName.lastIndexOf(47) >= 0) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                s.append(fileName);
                int line = this.getLineNumber();
                if (line > 0) {
                    s.append(":" + this.getLineNumber());
                }
            }
            return s.toString();
        }
    }
}

