/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.daisy.common.xproc.XProcPipelineInfo;

public final class XProcInput {
    private static final List<Supplier<Source>> emptySources = ImmutableList.of();
    private static final Map<QName, String> emptyParams = ImmutableMap.of();
    private final Map<String, List<Supplier<Source>>> inputs;
    private final Map<String, Map<QName, String>> parameters;
    private final Map<QName, Object> options;

    private XProcInput(Map<String, List<Supplier<Source>>> inputs, Map<String, Map<QName, String>> parameters, Map<QName, Object> options) {
        ImmutableMap.Builder inputsBuilder = ImmutableMap.builder();
        for (String key : inputs.keySet()) {
            inputsBuilder.put((Object)key, (Object)ImmutableList.copyOf((Collection)inputs.get(key)));
        }
        this.inputs = inputsBuilder.build();
        ImmutableMap.Builder parametersBuilder = ImmutableMap.builder();
        for (String key : parameters.keySet()) {
            parametersBuilder.put((Object)key, (Object)ImmutableMap.copyOf(parameters.get(key)));
        }
        this.parameters = parametersBuilder.build();
        this.options = ImmutableMap.copyOf((Map)Maps.filterValues(options, (Predicate)Predicates.notNull()));
    }

    public Iterable<Supplier<Source>> getInputs(String port) {
        return this.inputs.containsKey(port) ? ImmutableList.copyOf((Collection)this.inputs.get(port)) : emptySources;
    }

    public Map<QName, String> getParameters(String port) {
        return this.parameters.containsKey(port) ? ImmutableMap.copyOf(this.parameters.get(port)) : emptyParams;
    }

    public Map<QName, Object> getOptions() {
        return this.options;
    }

    public static final class Builder {
        private final XProcPipelineInfo info;
        private final HashMap<String, List<Supplier<Source>>> inputs = Maps.newHashMap();
        private final Map<String, Map<QName, String>> parameters = Maps.newHashMap();
        private final Map<QName, Object> options = Maps.newHashMap();

        public Builder() {
            this.info = null;
        }

        public Builder(XProcPipelineInfo info) {
            this.info = info;
        }

        public Builder withInput(String port, Supplier<Source> source) {
            if (this.inputs.containsKey(port)) {
                this.inputs.get(port).add(source);
            } else {
                LinkedList resources = Lists.newLinkedList();
                resources.add(source);
                this.inputs.put(port, resources);
            }
            return this;
        }

        public Builder withOption(QName name, Object value) {
            this.options.put(name, value);
            return this;
        }

        public Builder withParameter(String port, QName name, String value) {
            if (this.parameters.containsKey(port)) {
                this.parameters.get(port).put(name, value);
            } else {
                HashMap<QName, String> params = new HashMap<QName, String>();
                params.put(name, value);
                this.parameters.put(port, params);
            }
            return this;
        }

        public XProcInput build() {
            return new XProcInput(this.inputs, this.parameters, this.options);
        }
    }
}

