/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class XProcOptionInfo {
    private final QName name;
    private final NamespaceContext nsContext;
    private final String type;
    private final boolean isRequired;
    private final String select;

    public static XProcOptionInfo newOption(QName name, NamespaceContext nsContext, String type, boolean isRequired, String select) {
        return new XProcOptionInfo(name, nsContext, type, isRequired, select);
    }

    public static XProcOptionInfo newOption(QName name, String type, boolean isRequired, String select) {
        return new XProcOptionInfo(name, null, type, isRequired, select);
    }

    public static XProcOptionInfo newOption(QName name, boolean isRequired, String select) {
        return new XProcOptionInfo(name, null, null, isRequired, select);
    }

    protected XProcOptionInfo(QName name, String type, boolean isRequired, String select) {
        this(name, null, type, isRequired, select);
    }

    protected XProcOptionInfo(QName name, NamespaceContext nsContext, String type, boolean isRequired, String select) {
        if (isRequired && select != null) {
            throw new IllegalArgumentException("A required option can not have a select statement");
        }
        this.name = name;
        this.nsContext = nsContext;
        this.type = type;
        this.isRequired = isRequired;
        this.select = select;
    }

    public QName getName() {
        return this.name;
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getSelect() {
        return this.select;
    }

    public String toString() {
        return String.format("XProcOptionInfo (%s) [select=%s,required=%s]", this.name, this.select, this.isRequired);
    }
}

