/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;

public class XProcOutput {
    private final Map<String, Supplier<Result>> outputs;

    private XProcOutput(Map<String, Supplier<Result>> outputs) {
        this.outputs = ImmutableMap.copyOf(outputs);
    }

    public Supplier<Result> getResultProvider(String port) {
        return this.outputs.get(port);
    }

    public static final class Builder {
        private final HashMap<String, Supplier<Result>> outputs = Maps.newHashMap();

        public Builder withOutput(String port, Supplier<Result> result) {
            if (result != null) {
                this.outputs.put(port, result);
            }
            return this;
        }

        public XProcOutput build() {
            return new XProcOutput(this.outputs);
        }
    }
}

